/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.FecOutputSettings;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.model.UdpContainerSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UdpOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UdpOutputSettings> {
    private static final SdkField<Integer> BUFFER_MSEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BufferMsec").getter(UdpOutputSettings.getter(UdpOutputSettings::bufferMsec)).setter(UdpOutputSettings.setter(Builder::bufferMsec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufferMsec").build()}).build();
    private static final SdkField<UdpContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerSettings").getter(UdpOutputSettings.getter(UdpOutputSettings::containerSettings)).setter(UdpOutputSettings.setter(Builder::containerSettings)).constructor(UdpContainerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()}).build();
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(UdpOutputSettings.getter(UdpOutputSettings::destination)).setter(UdpOutputSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<FecOutputSettings> FEC_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FecOutputSettings").getter(UdpOutputSettings.getter(UdpOutputSettings::fecOutputSettings)).setter(UdpOutputSettings.setter(Builder::fecOutputSettings)).constructor(FecOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fecOutputSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUFFER_MSEC_FIELD, CONTAINER_SETTINGS_FIELD, DESTINATION_FIELD, FEC_OUTPUT_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer bufferMsec;
    private final UdpContainerSettings containerSettings;
    private final OutputLocationRef destination;
    private final FecOutputSettings fecOutputSettings;

    private UdpOutputSettings(BuilderImpl builder) {
        this.bufferMsec = builder.bufferMsec;
        this.containerSettings = builder.containerSettings;
        this.destination = builder.destination;
        this.fecOutputSettings = builder.fecOutputSettings;
    }

    public final Integer bufferMsec() {
        return this.bufferMsec;
    }

    public final UdpContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final FecOutputSettings fecOutputSettings() {
        return this.fecOutputSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferMsec());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.fecOutputSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UdpOutputSettings)) {
            return false;
        }
        UdpOutputSettings other = (UdpOutputSettings)obj;
        return Objects.equals(this.bufferMsec(), other.bufferMsec()) && Objects.equals(this.containerSettings(), other.containerSettings()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.fecOutputSettings(), other.fecOutputSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UdpOutputSettings").add("BufferMsec", (Object)this.bufferMsec()).add("ContainerSettings", (Object)this.containerSettings()).add("Destination", (Object)this.destination()).add("FecOutputSettings", (Object)this.fecOutputSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BufferMsec": {
                return Optional.ofNullable(clazz.cast(this.bufferMsec()));
            }
            case "ContainerSettings": {
                return Optional.ofNullable(clazz.cast(this.containerSettings()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "FecOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.fecOutputSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UdpOutputSettings, T> g) {
        return obj -> g.apply((UdpOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bufferMsec;
        private UdpContainerSettings containerSettings;
        private OutputLocationRef destination;
        private FecOutputSettings fecOutputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UdpOutputSettings model) {
            this.bufferMsec(model.bufferMsec);
            this.containerSettings(model.containerSettings);
            this.destination(model.destination);
            this.fecOutputSettings(model.fecOutputSettings);
        }

        public final Integer getBufferMsec() {
            return this.bufferMsec;
        }

        @Override
        public final Builder bufferMsec(Integer bufferMsec) {
            this.bufferMsec = bufferMsec;
            return this;
        }

        public final void setBufferMsec(Integer bufferMsec) {
            this.bufferMsec = bufferMsec;
        }

        public final UdpContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(UdpContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(UdpContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final FecOutputSettings.Builder getFecOutputSettings() {
            return this.fecOutputSettings != null ? this.fecOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder fecOutputSettings(FecOutputSettings fecOutputSettings) {
            this.fecOutputSettings = fecOutputSettings;
            return this;
        }

        public final void setFecOutputSettings(FecOutputSettings.BuilderImpl fecOutputSettings) {
            this.fecOutputSettings = fecOutputSettings != null ? fecOutputSettings.build() : null;
        }

        public UdpOutputSettings build() {
            return new UdpOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UdpOutputSettings> {
        public Builder bufferMsec(Integer var1);

        public Builder containerSettings(UdpContainerSettings var1);

        default public Builder containerSettings(Consumer<UdpContainerSettings.Builder> containerSettings) {
            return this.containerSettings((UdpContainerSettings)((UdpContainerSettings.Builder)UdpContainerSettings.builder().applyMutation(containerSettings)).build());
        }

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder fecOutputSettings(FecOutputSettings var1);

        default public Builder fecOutputSettings(Consumer<FecOutputSettings.Builder> fecOutputSettings) {
            return this.fecOutputSettings((FecOutputSettings)((FecOutputSettings.Builder)FecOutputSettings.builder().applyMutation(fecOutputSettings)).build());
        }
    }
}

