/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InputFilter {
    AUTO("AUTO"),
    DISABLED("DISABLED"),
    FORCED("FORCED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputFilter.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputFilter> knownValues() {
        return Stream.of(InputFilter.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

