/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HlsIvSource {
    EXPLICIT("EXPLICIT"),
    FOLLOWS_SEGMENT_NUMBER("FOLLOWS_SEGMENT_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HlsIvSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsIvSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HlsIvSource.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsIvSource> knownValues() {
        return Stream.of(HlsIvSource.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

