/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.FailoverCondition;
import software.amazon.awssdk.services.medialive.model.InputPreference;
import software.amazon.awssdk.services.medialive.model.___listOfFailoverConditionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomaticInputFailoverSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomaticInputFailoverSettings> {
    private static final SdkField<Integer> ERROR_CLEAR_TIME_MSEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ErrorClearTimeMsec").getter(AutomaticInputFailoverSettings.getter(AutomaticInputFailoverSettings::errorClearTimeMsec)).setter(AutomaticInputFailoverSettings.setter(Builder::errorClearTimeMsec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorClearTimeMsec").build()}).build();
    private static final SdkField<List<FailoverCondition>> FAILOVER_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailoverConditions").getter(AutomaticInputFailoverSettings.getter(AutomaticInputFailoverSettings::failoverConditions)).setter(AutomaticInputFailoverSettings.setter(Builder::failoverConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failoverConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailoverCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputPreference").getter(AutomaticInputFailoverSettings.getter(AutomaticInputFailoverSettings::inputPreferenceAsString)).setter(AutomaticInputFailoverSettings.setter(Builder::inputPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPreference").build()}).build();
    private static final SdkField<String> SECONDARY_INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryInputId").getter(AutomaticInputFailoverSettings.getter(AutomaticInputFailoverSettings::secondaryInputId)).setter(AutomaticInputFailoverSettings.setter(Builder::secondaryInputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryInputId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CLEAR_TIME_MSEC_FIELD, FAILOVER_CONDITIONS_FIELD, INPUT_PREFERENCE_FIELD, SECONDARY_INPUT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer errorClearTimeMsec;
    private final List<FailoverCondition> failoverConditions;
    private final String inputPreference;
    private final String secondaryInputId;

    private AutomaticInputFailoverSettings(BuilderImpl builder) {
        this.errorClearTimeMsec = builder.errorClearTimeMsec;
        this.failoverConditions = builder.failoverConditions;
        this.inputPreference = builder.inputPreference;
        this.secondaryInputId = builder.secondaryInputId;
    }

    public final Integer errorClearTimeMsec() {
        return this.errorClearTimeMsec;
    }

    public final boolean hasFailoverConditions() {
        return this.failoverConditions != null && !(this.failoverConditions instanceof SdkAutoConstructList);
    }

    public final List<FailoverCondition> failoverConditions() {
        return this.failoverConditions;
    }

    public final InputPreference inputPreference() {
        return InputPreference.fromValue(this.inputPreference);
    }

    public final String inputPreferenceAsString() {
        return this.inputPreference;
    }

    public final String secondaryInputId() {
        return this.secondaryInputId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorClearTimeMsec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailoverConditions() ? this.failoverConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryInputId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomaticInputFailoverSettings)) {
            return false;
        }
        AutomaticInputFailoverSettings other = (AutomaticInputFailoverSettings)obj;
        return Objects.equals(this.errorClearTimeMsec(), other.errorClearTimeMsec()) && this.hasFailoverConditions() == other.hasFailoverConditions() && Objects.equals(this.failoverConditions(), other.failoverConditions()) && Objects.equals(this.inputPreferenceAsString(), other.inputPreferenceAsString()) && Objects.equals(this.secondaryInputId(), other.secondaryInputId());
    }

    public final String toString() {
        return ToString.builder((String)"AutomaticInputFailoverSettings").add("ErrorClearTimeMsec", (Object)this.errorClearTimeMsec()).add("FailoverConditions", this.hasFailoverConditions() ? this.failoverConditions() : null).add("InputPreference", (Object)this.inputPreferenceAsString()).add("SecondaryInputId", (Object)this.secondaryInputId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorClearTimeMsec": {
                return Optional.ofNullable(clazz.cast(this.errorClearTimeMsec()));
            }
            case "FailoverConditions": {
                return Optional.ofNullable(clazz.cast(this.failoverConditions()));
            }
            case "InputPreference": {
                return Optional.ofNullable(clazz.cast(this.inputPreferenceAsString()));
            }
            case "SecondaryInputId": {
                return Optional.ofNullable(clazz.cast(this.secondaryInputId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomaticInputFailoverSettings, T> g) {
        return obj -> g.apply((AutomaticInputFailoverSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer errorClearTimeMsec;
        private List<FailoverCondition> failoverConditions = DefaultSdkAutoConstructList.getInstance();
        private String inputPreference;
        private String secondaryInputId;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomaticInputFailoverSettings model) {
            this.errorClearTimeMsec(model.errorClearTimeMsec);
            this.failoverConditions(model.failoverConditions);
            this.inputPreference(model.inputPreference);
            this.secondaryInputId(model.secondaryInputId);
        }

        public final Integer getErrorClearTimeMsec() {
            return this.errorClearTimeMsec;
        }

        @Override
        public final Builder errorClearTimeMsec(Integer errorClearTimeMsec) {
            this.errorClearTimeMsec = errorClearTimeMsec;
            return this;
        }

        public final void setErrorClearTimeMsec(Integer errorClearTimeMsec) {
            this.errorClearTimeMsec = errorClearTimeMsec;
        }

        public final Collection<FailoverCondition.Builder> getFailoverConditions() {
            if (this.failoverConditions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failoverConditions != null ? (Collection)this.failoverConditions.stream().map(FailoverCondition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failoverConditions(Collection<FailoverCondition> failoverConditions) {
            this.failoverConditions = ___listOfFailoverConditionCopier.copy(failoverConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failoverConditions(FailoverCondition ... failoverConditions) {
            this.failoverConditions(Arrays.asList(failoverConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failoverConditions(Consumer<FailoverCondition.Builder> ... failoverConditions) {
            this.failoverConditions(Stream.of(failoverConditions).map(c -> (FailoverCondition)((FailoverCondition.Builder)FailoverCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailoverConditions(Collection<FailoverCondition.BuilderImpl> failoverConditions) {
            this.failoverConditions = ___listOfFailoverConditionCopier.copyFromBuilder(failoverConditions);
        }

        public final String getInputPreference() {
            return this.inputPreference;
        }

        @Override
        public final Builder inputPreference(String inputPreference) {
            this.inputPreference = inputPreference;
            return this;
        }

        @Override
        public final Builder inputPreference(InputPreference inputPreference) {
            this.inputPreference(inputPreference == null ? null : inputPreference.toString());
            return this;
        }

        public final void setInputPreference(String inputPreference) {
            this.inputPreference = inputPreference;
        }

        public final String getSecondaryInputId() {
            return this.secondaryInputId;
        }

        @Override
        public final Builder secondaryInputId(String secondaryInputId) {
            this.secondaryInputId = secondaryInputId;
            return this;
        }

        public final void setSecondaryInputId(String secondaryInputId) {
            this.secondaryInputId = secondaryInputId;
        }

        public AutomaticInputFailoverSettings build() {
            return new AutomaticInputFailoverSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomaticInputFailoverSettings> {
        public Builder errorClearTimeMsec(Integer var1);

        public Builder failoverConditions(Collection<FailoverCondition> var1);

        public Builder failoverConditions(FailoverCondition ... var1);

        public Builder failoverConditions(Consumer<FailoverCondition.Builder> ... var1);

        public Builder inputPreference(String var1);

        public Builder inputPreference(InputPreference var1);

        public Builder secondaryInputId(String var1);
    }
}

