/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.M3u8NielsenId3Behavior;
import software.amazon.awssdk.services.medialive.model.M3u8PcrControl;
import software.amazon.awssdk.services.medialive.model.M3u8Scte35Behavior;
import software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M3u8Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, M3u8Settings> {
    private static final SdkField<Integer> AUDIO_FRAMES_PER_PES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AudioFramesPerPes").getter(M3u8Settings.getter(M3u8Settings::audioFramesPerPes)).setter(M3u8Settings.setter(Builder::audioFramesPerPes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioFramesPerPes").build()}).build();
    private static final SdkField<String> AUDIO_PIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioPids").getter(M3u8Settings.getter(M3u8Settings::audioPids)).setter(M3u8Settings.setter(Builder::audioPids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioPids").build()}).build();
    private static final SdkField<String> ECM_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EcmPid").getter(M3u8Settings.getter(M3u8Settings::ecmPid)).setter(M3u8Settings.setter(Builder::ecmPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecmPid").build()}).build();
    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NielsenId3Behavior").getter(M3u8Settings.getter(M3u8Settings::nielsenId3BehaviorAsString)).setter(M3u8Settings.setter(Builder::nielsenId3Behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build()}).build();
    private static final SdkField<Integer> PAT_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PatInterval").getter(M3u8Settings.getter(M3u8Settings::patInterval)).setter(M3u8Settings.setter(Builder::patInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patInterval").build()}).build();
    private static final SdkField<String> PCR_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PcrControl").getter(M3u8Settings.getter(M3u8Settings::pcrControlAsString)).setter(M3u8Settings.setter(Builder::pcrControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrControl").build()}).build();
    private static final SdkField<Integer> PCR_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PcrPeriod").getter(M3u8Settings.getter(M3u8Settings::pcrPeriod)).setter(M3u8Settings.setter(Builder::pcrPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPeriod").build()}).build();
    private static final SdkField<String> PCR_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PcrPid").getter(M3u8Settings.getter(M3u8Settings::pcrPid)).setter(M3u8Settings.setter(Builder::pcrPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPid").build()}).build();
    private static final SdkField<Integer> PMT_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PmtInterval").getter(M3u8Settings.getter(M3u8Settings::pmtInterval)).setter(M3u8Settings.setter(Builder::pmtInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtInterval").build()}).build();
    private static final SdkField<String> PMT_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PmtPid").getter(M3u8Settings.getter(M3u8Settings::pmtPid)).setter(M3u8Settings.setter(Builder::pmtPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtPid").build()}).build();
    private static final SdkField<Integer> PROGRAM_NUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramNum").getter(M3u8Settings.getter(M3u8Settings::programNum)).setter(M3u8Settings.setter(Builder::programNum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNum").build()}).build();
    private static final SdkField<String> SCTE35_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Behavior").getter(M3u8Settings.getter(M3u8Settings::scte35BehaviorAsString)).setter(M3u8Settings.setter(Builder::scte35Behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Behavior").build()}).build();
    private static final SdkField<String> SCTE35_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Pid").getter(M3u8Settings.getter(M3u8Settings::scte35Pid)).setter(M3u8Settings.setter(Builder::scte35Pid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Pid").build()}).build();
    private static final SdkField<String> TIMED_METADATA_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadataBehavior").getter(M3u8Settings.getter(M3u8Settings::timedMetadataBehaviorAsString)).setter(M3u8Settings.setter(Builder::timedMetadataBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataBehavior").build()}).build();
    private static final SdkField<String> TIMED_METADATA_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadataPid").getter(M3u8Settings.getter(M3u8Settings::timedMetadataPid)).setter(M3u8Settings.setter(Builder::timedMetadataPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataPid").build()}).build();
    private static final SdkField<Integer> TRANSPORT_STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransportStreamId").getter(M3u8Settings.getter(M3u8Settings::transportStreamId)).setter(M3u8Settings.setter(Builder::transportStreamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamId").build()}).build();
    private static final SdkField<String> VIDEO_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoPid").getter(M3u8Settings.getter(M3u8Settings::videoPid)).setter(M3u8Settings.setter(Builder::videoPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoPid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FRAMES_PER_PES_FIELD, AUDIO_PIDS_FIELD, ECM_PID_FIELD, NIELSEN_ID3_BEHAVIOR_FIELD, PAT_INTERVAL_FIELD, PCR_CONTROL_FIELD, PCR_PERIOD_FIELD, PCR_PID_FIELD, PMT_INTERVAL_FIELD, PMT_PID_FIELD, PROGRAM_NUM_FIELD, SCTE35_BEHAVIOR_FIELD, SCTE35_PID_FIELD, TIMED_METADATA_BEHAVIOR_FIELD, TIMED_METADATA_PID_FIELD, TRANSPORT_STREAM_ID_FIELD, VIDEO_PID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer audioFramesPerPes;
    private final String audioPids;
    private final String ecmPid;
    private final String nielsenId3Behavior;
    private final Integer patInterval;
    private final String pcrControl;
    private final Integer pcrPeriod;
    private final String pcrPid;
    private final Integer pmtInterval;
    private final String pmtPid;
    private final Integer programNum;
    private final String scte35Behavior;
    private final String scte35Pid;
    private final String timedMetadataBehavior;
    private final String timedMetadataPid;
    private final Integer transportStreamId;
    private final String videoPid;

    private M3u8Settings(BuilderImpl builder) {
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioPids = builder.audioPids;
        this.ecmPid = builder.ecmPid;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.patInterval = builder.patInterval;
        this.pcrControl = builder.pcrControl;
        this.pcrPeriod = builder.pcrPeriod;
        this.pcrPid = builder.pcrPid;
        this.pmtInterval = builder.pmtInterval;
        this.pmtPid = builder.pmtPid;
        this.programNum = builder.programNum;
        this.scte35Behavior = builder.scte35Behavior;
        this.scte35Pid = builder.scte35Pid;
        this.timedMetadataBehavior = builder.timedMetadataBehavior;
        this.timedMetadataPid = builder.timedMetadataPid;
        this.transportStreamId = builder.transportStreamId;
        this.videoPid = builder.videoPid;
    }

    public Integer audioFramesPerPes() {
        return this.audioFramesPerPes;
    }

    public String audioPids() {
        return this.audioPids;
    }

    public String ecmPid() {
        return this.ecmPid;
    }

    public M3u8NielsenId3Behavior nielsenId3Behavior() {
        return M3u8NielsenId3Behavior.fromValue(this.nielsenId3Behavior);
    }

    public String nielsenId3BehaviorAsString() {
        return this.nielsenId3Behavior;
    }

    public Integer patInterval() {
        return this.patInterval;
    }

    public M3u8PcrControl pcrControl() {
        return M3u8PcrControl.fromValue(this.pcrControl);
    }

    public String pcrControlAsString() {
        return this.pcrControl;
    }

    public Integer pcrPeriod() {
        return this.pcrPeriod;
    }

    public String pcrPid() {
        return this.pcrPid;
    }

    public Integer pmtInterval() {
        return this.pmtInterval;
    }

    public String pmtPid() {
        return this.pmtPid;
    }

    public Integer programNum() {
        return this.programNum;
    }

    public M3u8Scte35Behavior scte35Behavior() {
        return M3u8Scte35Behavior.fromValue(this.scte35Behavior);
    }

    public String scte35BehaviorAsString() {
        return this.scte35Behavior;
    }

    public String scte35Pid() {
        return this.scte35Pid;
    }

    public M3u8TimedMetadataBehavior timedMetadataBehavior() {
        return M3u8TimedMetadataBehavior.fromValue(this.timedMetadataBehavior);
    }

    public String timedMetadataBehaviorAsString() {
        return this.timedMetadataBehavior;
    }

    public String timedMetadataPid() {
        return this.timedMetadataPid;
    }

    public Integer transportStreamId() {
        return this.transportStreamId;
    }

    public String videoPid() {
        return this.videoPid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioPids());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecmPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.patInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNum());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoPid());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M3u8Settings)) {
            return false;
        }
        M3u8Settings other = (M3u8Settings)obj;
        return Objects.equals(this.audioFramesPerPes(), other.audioFramesPerPes()) && Objects.equals(this.audioPids(), other.audioPids()) && Objects.equals(this.ecmPid(), other.ecmPid()) && Objects.equals(this.nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString()) && Objects.equals(this.patInterval(), other.patInterval()) && Objects.equals(this.pcrControlAsString(), other.pcrControlAsString()) && Objects.equals(this.pcrPeriod(), other.pcrPeriod()) && Objects.equals(this.pcrPid(), other.pcrPid()) && Objects.equals(this.pmtInterval(), other.pmtInterval()) && Objects.equals(this.pmtPid(), other.pmtPid()) && Objects.equals(this.programNum(), other.programNum()) && Objects.equals(this.scte35BehaviorAsString(), other.scte35BehaviorAsString()) && Objects.equals(this.scte35Pid(), other.scte35Pid()) && Objects.equals(this.timedMetadataBehaviorAsString(), other.timedMetadataBehaviorAsString()) && Objects.equals(this.timedMetadataPid(), other.timedMetadataPid()) && Objects.equals(this.transportStreamId(), other.transportStreamId()) && Objects.equals(this.videoPid(), other.videoPid());
    }

    public String toString() {
        return ToString.builder((String)"M3u8Settings").add("AudioFramesPerPes", (Object)this.audioFramesPerPes()).add("AudioPids", (Object)this.audioPids()).add("EcmPid", (Object)this.ecmPid()).add("NielsenId3Behavior", (Object)this.nielsenId3BehaviorAsString()).add("PatInterval", (Object)this.patInterval()).add("PcrControl", (Object)this.pcrControlAsString()).add("PcrPeriod", (Object)this.pcrPeriod()).add("PcrPid", (Object)this.pcrPid()).add("PmtInterval", (Object)this.pmtInterval()).add("PmtPid", (Object)this.pmtPid()).add("ProgramNum", (Object)this.programNum()).add("Scte35Behavior", (Object)this.scte35BehaviorAsString()).add("Scte35Pid", (Object)this.scte35Pid()).add("TimedMetadataBehavior", (Object)this.timedMetadataBehaviorAsString()).add("TimedMetadataPid", (Object)this.timedMetadataPid()).add("TransportStreamId", (Object)this.transportStreamId()).add("VideoPid", (Object)this.videoPid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioFramesPerPes": {
                return Optional.ofNullable(clazz.cast(this.audioFramesPerPes()));
            }
            case "AudioPids": {
                return Optional.ofNullable(clazz.cast(this.audioPids()));
            }
            case "EcmPid": {
                return Optional.ofNullable(clazz.cast(this.ecmPid()));
            }
            case "NielsenId3Behavior": {
                return Optional.ofNullable(clazz.cast(this.nielsenId3BehaviorAsString()));
            }
            case "PatInterval": {
                return Optional.ofNullable(clazz.cast(this.patInterval()));
            }
            case "PcrControl": {
                return Optional.ofNullable(clazz.cast(this.pcrControlAsString()));
            }
            case "PcrPeriod": {
                return Optional.ofNullable(clazz.cast(this.pcrPeriod()));
            }
            case "PcrPid": {
                return Optional.ofNullable(clazz.cast(this.pcrPid()));
            }
            case "PmtInterval": {
                return Optional.ofNullable(clazz.cast(this.pmtInterval()));
            }
            case "PmtPid": {
                return Optional.ofNullable(clazz.cast(this.pmtPid()));
            }
            case "ProgramNum": {
                return Optional.ofNullable(clazz.cast(this.programNum()));
            }
            case "Scte35Behavior": {
                return Optional.ofNullable(clazz.cast(this.scte35BehaviorAsString()));
            }
            case "Scte35Pid": {
                return Optional.ofNullable(clazz.cast(this.scte35Pid()));
            }
            case "TimedMetadataBehavior": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataBehaviorAsString()));
            }
            case "TimedMetadataPid": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataPid()));
            }
            case "TransportStreamId": {
                return Optional.ofNullable(clazz.cast(this.transportStreamId()));
            }
            case "VideoPid": {
                return Optional.ofNullable(clazz.cast(this.videoPid()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M3u8Settings, T> g) {
        return obj -> g.apply((M3u8Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer audioFramesPerPes;
        private String audioPids;
        private String ecmPid;
        private String nielsenId3Behavior;
        private Integer patInterval;
        private String pcrControl;
        private Integer pcrPeriod;
        private String pcrPid;
        private Integer pmtInterval;
        private String pmtPid;
        private Integer programNum;
        private String scte35Behavior;
        private String scte35Pid;
        private String timedMetadataBehavior;
        private String timedMetadataPid;
        private Integer transportStreamId;
        private String videoPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M3u8Settings model) {
            this.audioFramesPerPes(model.audioFramesPerPes);
            this.audioPids(model.audioPids);
            this.ecmPid(model.ecmPid);
            this.nielsenId3Behavior(model.nielsenId3Behavior);
            this.patInterval(model.patInterval);
            this.pcrControl(model.pcrControl);
            this.pcrPeriod(model.pcrPeriod);
            this.pcrPid(model.pcrPid);
            this.pmtInterval(model.pmtInterval);
            this.pmtPid(model.pmtPid);
            this.programNum(model.programNum);
            this.scte35Behavior(model.scte35Behavior);
            this.scte35Pid(model.scte35Pid);
            this.timedMetadataBehavior(model.timedMetadataBehavior);
            this.timedMetadataPid(model.timedMetadataPid);
            this.transportStreamId(model.transportStreamId);
            this.videoPid(model.videoPid);
        }

        public final Integer getAudioFramesPerPes() {
            return this.audioFramesPerPes;
        }

        @Override
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        public final String getAudioPids() {
            return this.audioPids;
        }

        @Override
        public final Builder audioPids(String audioPids) {
            this.audioPids = audioPids;
            return this;
        }

        public final void setAudioPids(String audioPids) {
            this.audioPids = audioPids;
        }

        public final String getEcmPid() {
            return this.ecmPid;
        }

        @Override
        public final Builder ecmPid(String ecmPid) {
            this.ecmPid = ecmPid;
            return this;
        }

        public final void setEcmPid(String ecmPid) {
            this.ecmPid = ecmPid;
        }

        public final String getNielsenId3Behavior() {
            return this.nielsenId3Behavior;
        }

        @Override
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        public final Builder nielsenId3Behavior(M3u8NielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        public final Integer getPatInterval() {
            return this.patInterval;
        }

        @Override
        public final Builder patInterval(Integer patInterval) {
            this.patInterval = patInterval;
            return this;
        }

        public final void setPatInterval(Integer patInterval) {
            this.patInterval = patInterval;
        }

        public final String getPcrControl() {
            return this.pcrControl;
        }

        @Override
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        public final Builder pcrControl(M3u8PcrControl pcrControl) {
            this.pcrControl(pcrControl == null ? null : pcrControl.toString());
            return this;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        public final Integer getPcrPeriod() {
            return this.pcrPeriod;
        }

        @Override
        public final Builder pcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
            return this;
        }

        public final void setPcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
        }

        public final String getPcrPid() {
            return this.pcrPid;
        }

        @Override
        public final Builder pcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final void setPcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
        }

        public final Integer getPmtInterval() {
            return this.pmtInterval;
        }

        @Override
        public final Builder pmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
            return this;
        }

        public final void setPmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
        }

        public final String getPmtPid() {
            return this.pmtPid;
        }

        @Override
        public final Builder pmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final void setPmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
        }

        public final Integer getProgramNum() {
            return this.programNum;
        }

        @Override
        public final Builder programNum(Integer programNum) {
            this.programNum = programNum;
            return this;
        }

        public final void setProgramNum(Integer programNum) {
            this.programNum = programNum;
        }

        public final String getScte35Behavior() {
            return this.scte35Behavior;
        }

        @Override
        public final Builder scte35Behavior(String scte35Behavior) {
            this.scte35Behavior = scte35Behavior;
            return this;
        }

        @Override
        public final Builder scte35Behavior(M3u8Scte35Behavior scte35Behavior) {
            this.scte35Behavior(scte35Behavior == null ? null : scte35Behavior.toString());
            return this;
        }

        public final void setScte35Behavior(String scte35Behavior) {
            this.scte35Behavior = scte35Behavior;
        }

        public final String getScte35Pid() {
            return this.scte35Pid;
        }

        @Override
        public final Builder scte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final void setScte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        public final String getTimedMetadataBehavior() {
            return this.timedMetadataBehavior;
        }

        @Override
        public final Builder timedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
            return this;
        }

        @Override
        public final Builder timedMetadataBehavior(M3u8TimedMetadataBehavior timedMetadataBehavior) {
            this.timedMetadataBehavior(timedMetadataBehavior == null ? null : timedMetadataBehavior.toString());
            return this;
        }

        public final void setTimedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
        }

        public final String getTimedMetadataPid() {
            return this.timedMetadataPid;
        }

        @Override
        public final Builder timedMetadataPid(String timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
            return this;
        }

        public final void setTimedMetadataPid(String timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
        }

        public final Integer getTransportStreamId() {
            return this.transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final String getVideoPid() {
            return this.videoPid;
        }

        @Override
        public final Builder videoPid(String videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        public final void setVideoPid(String videoPid) {
            this.videoPid = videoPid;
        }

        public M3u8Settings build() {
            return new M3u8Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, M3u8Settings> {
        public Builder audioFramesPerPes(Integer var1);

        public Builder audioPids(String var1);

        public Builder ecmPid(String var1);

        public Builder nielsenId3Behavior(String var1);

        public Builder nielsenId3Behavior(M3u8NielsenId3Behavior var1);

        public Builder patInterval(Integer var1);

        public Builder pcrControl(String var1);

        public Builder pcrControl(M3u8PcrControl var1);

        public Builder pcrPeriod(Integer var1);

        public Builder pcrPid(String var1);

        public Builder pmtInterval(Integer var1);

        public Builder pmtPid(String var1);

        public Builder programNum(Integer var1);

        public Builder scte35Behavior(String var1);

        public Builder scte35Behavior(M3u8Scte35Behavior var1);

        public Builder scte35Pid(String var1);

        public Builder timedMetadataBehavior(String var1);

        public Builder timedMetadataBehavior(M3u8TimedMetadataBehavior var1);

        public Builder timedMetadataPid(String var1);

        public Builder transportStreamId(Integer var1);

        public Builder videoPid(String var1);
    }
}

