/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioLanguageSelection;
import software.amazon.awssdk.services.medialive.model.AudioPidSelection;
import software.amazon.awssdk.services.medialive.model.AudioTrackSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioSelectorSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioSelectorSettings> {
    private static final SdkField<AudioLanguageSelection> AUDIO_LANGUAGE_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioLanguageSelection").getter(AudioSelectorSettings.getter(AudioSelectorSettings::audioLanguageSelection)).setter(AudioSelectorSettings.setter(Builder::audioLanguageSelection)).constructor(AudioLanguageSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioLanguageSelection").build()}).build();
    private static final SdkField<AudioPidSelection> AUDIO_PID_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioPidSelection").getter(AudioSelectorSettings.getter(AudioSelectorSettings::audioPidSelection)).setter(AudioSelectorSettings.setter(Builder::audioPidSelection)).constructor(AudioPidSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioPidSelection").build()}).build();
    private static final SdkField<AudioTrackSelection> AUDIO_TRACK_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioTrackSelection").getter(AudioSelectorSettings.getter(AudioSelectorSettings::audioTrackSelection)).setter(AudioSelectorSettings.setter(Builder::audioTrackSelection)).constructor(AudioTrackSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_LANGUAGE_SELECTION_FIELD, AUDIO_PID_SELECTION_FIELD, AUDIO_TRACK_SELECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AudioLanguageSelection audioLanguageSelection;
    private final AudioPidSelection audioPidSelection;
    private final AudioTrackSelection audioTrackSelection;

    private AudioSelectorSettings(BuilderImpl builder) {
        this.audioLanguageSelection = builder.audioLanguageSelection;
        this.audioPidSelection = builder.audioPidSelection;
        this.audioTrackSelection = builder.audioTrackSelection;
    }

    public final AudioLanguageSelection audioLanguageSelection() {
        return this.audioLanguageSelection;
    }

    public final AudioPidSelection audioPidSelection() {
        return this.audioPidSelection;
    }

    public final AudioTrackSelection audioTrackSelection() {
        return this.audioTrackSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioLanguageSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioPidSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTrackSelection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelectorSettings)) {
            return false;
        }
        AudioSelectorSettings other = (AudioSelectorSettings)obj;
        return Objects.equals(this.audioLanguageSelection(), other.audioLanguageSelection()) && Objects.equals(this.audioPidSelection(), other.audioPidSelection()) && Objects.equals(this.audioTrackSelection(), other.audioTrackSelection());
    }

    public final String toString() {
        return ToString.builder((String)"AudioSelectorSettings").add("AudioLanguageSelection", (Object)this.audioLanguageSelection()).add("AudioPidSelection", (Object)this.audioPidSelection()).add("AudioTrackSelection", (Object)this.audioTrackSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioLanguageSelection": {
                return Optional.ofNullable(clazz.cast(this.audioLanguageSelection()));
            }
            case "AudioPidSelection": {
                return Optional.ofNullable(clazz.cast(this.audioPidSelection()));
            }
            case "AudioTrackSelection": {
                return Optional.ofNullable(clazz.cast(this.audioTrackSelection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSelectorSettings, T> g) {
        return obj -> g.apply((AudioSelectorSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioLanguageSelection audioLanguageSelection;
        private AudioPidSelection audioPidSelection;
        private AudioTrackSelection audioTrackSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelectorSettings model) {
            this.audioLanguageSelection(model.audioLanguageSelection);
            this.audioPidSelection(model.audioPidSelection);
            this.audioTrackSelection(model.audioTrackSelection);
        }

        public final AudioLanguageSelection.Builder getAudioLanguageSelection() {
            return this.audioLanguageSelection != null ? this.audioLanguageSelection.toBuilder() : null;
        }

        @Override
        public final Builder audioLanguageSelection(AudioLanguageSelection audioLanguageSelection) {
            this.audioLanguageSelection = audioLanguageSelection;
            return this;
        }

        public final void setAudioLanguageSelection(AudioLanguageSelection.BuilderImpl audioLanguageSelection) {
            this.audioLanguageSelection = audioLanguageSelection != null ? audioLanguageSelection.build() : null;
        }

        public final AudioPidSelection.Builder getAudioPidSelection() {
            return this.audioPidSelection != null ? this.audioPidSelection.toBuilder() : null;
        }

        @Override
        public final Builder audioPidSelection(AudioPidSelection audioPidSelection) {
            this.audioPidSelection = audioPidSelection;
            return this;
        }

        public final void setAudioPidSelection(AudioPidSelection.BuilderImpl audioPidSelection) {
            this.audioPidSelection = audioPidSelection != null ? audioPidSelection.build() : null;
        }

        public final AudioTrackSelection.Builder getAudioTrackSelection() {
            return this.audioTrackSelection != null ? this.audioTrackSelection.toBuilder() : null;
        }

        @Override
        public final Builder audioTrackSelection(AudioTrackSelection audioTrackSelection) {
            this.audioTrackSelection = audioTrackSelection;
            return this;
        }

        public final void setAudioTrackSelection(AudioTrackSelection.BuilderImpl audioTrackSelection) {
            this.audioTrackSelection = audioTrackSelection != null ? audioTrackSelection.build() : null;
        }

        public AudioSelectorSettings build() {
            return new AudioSelectorSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioSelectorSettings> {
        public Builder audioLanguageSelection(AudioLanguageSelection var1);

        default public Builder audioLanguageSelection(Consumer<AudioLanguageSelection.Builder> audioLanguageSelection) {
            return this.audioLanguageSelection((AudioLanguageSelection)((AudioLanguageSelection.Builder)AudioLanguageSelection.builder().applyMutation(audioLanguageSelection)).build());
        }

        public Builder audioPidSelection(AudioPidSelection var1);

        default public Builder audioPidSelection(Consumer<AudioPidSelection.Builder> audioPidSelection) {
            return this.audioPidSelection((AudioPidSelection)((AudioPidSelection.Builder)AudioPidSelection.builder().applyMutation(audioPidSelection)).build());
        }

        public Builder audioTrackSelection(AudioTrackSelection var1);

        default public Builder audioTrackSelection(Consumer<AudioTrackSelection.Builder> audioTrackSelection) {
            return this.audioTrackSelection((AudioTrackSelection)((AudioTrackSelection.Builder)AudioTrackSelection.builder().applyMutation(audioTrackSelection)).build());
        }
    }
}

