/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableSettings;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInputDeviceRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateInputDeviceRequest> {
    private static final SdkField<InputDeviceConfigurableSettings> HD_DEVICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HdDeviceSettings").getter(UpdateInputDeviceRequest.getter(UpdateInputDeviceRequest::hdDeviceSettings)).setter(UpdateInputDeviceRequest.setter(Builder::hdDeviceSettings)).constructor(InputDeviceConfigurableSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdDeviceSettings").build()}).build();
    private static final SdkField<String> INPUT_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputDeviceId").getter(UpdateInputDeviceRequest.getter(UpdateInputDeviceRequest::inputDeviceId)).setter(UpdateInputDeviceRequest.setter(Builder::inputDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputDeviceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateInputDeviceRequest.getter(UpdateInputDeviceRequest::name)).setter(UpdateInputDeviceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<InputDeviceConfigurableSettings> UHD_DEVICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UhdDeviceSettings").getter(UpdateInputDeviceRequest.getter(UpdateInputDeviceRequest::uhdDeviceSettings)).setter(UpdateInputDeviceRequest.setter(Builder::uhdDeviceSettings)).constructor(InputDeviceConfigurableSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uhdDeviceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HD_DEVICE_SETTINGS_FIELD, INPUT_DEVICE_ID_FIELD, NAME_FIELD, UHD_DEVICE_SETTINGS_FIELD));
    private final InputDeviceConfigurableSettings hdDeviceSettings;
    private final String inputDeviceId;
    private final String name;
    private final InputDeviceConfigurableSettings uhdDeviceSettings;

    private UpdateInputDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.hdDeviceSettings = builder.hdDeviceSettings;
        this.inputDeviceId = builder.inputDeviceId;
        this.name = builder.name;
        this.uhdDeviceSettings = builder.uhdDeviceSettings;
    }

    public InputDeviceConfigurableSettings hdDeviceSettings() {
        return this.hdDeviceSettings;
    }

    public String inputDeviceId() {
        return this.inputDeviceId;
    }

    public String name() {
        return this.name;
    }

    public InputDeviceConfigurableSettings uhdDeviceSettings() {
        return this.uhdDeviceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.uhdDeviceSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputDeviceRequest)) {
            return false;
        }
        UpdateInputDeviceRequest other = (UpdateInputDeviceRequest)((Object)obj);
        return Objects.equals(this.hdDeviceSettings(), other.hdDeviceSettings()) && Objects.equals(this.inputDeviceId(), other.inputDeviceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.uhdDeviceSettings(), other.uhdDeviceSettings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateInputDeviceRequest").add("HdDeviceSettings", (Object)this.hdDeviceSettings()).add("InputDeviceId", (Object)this.inputDeviceId()).add("Name", (Object)this.name()).add("UhdDeviceSettings", (Object)this.uhdDeviceSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HdDeviceSettings": {
                return Optional.ofNullable(clazz.cast(this.hdDeviceSettings()));
            }
            case "InputDeviceId": {
                return Optional.ofNullable(clazz.cast(this.inputDeviceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "UhdDeviceSettings": {
                return Optional.ofNullable(clazz.cast(this.uhdDeviceSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputDeviceRequest, T> g) {
        return obj -> g.apply((UpdateInputDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private InputDeviceConfigurableSettings hdDeviceSettings;
        private String inputDeviceId;
        private String name;
        private InputDeviceConfigurableSettings uhdDeviceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputDeviceRequest model) {
            super(model);
            this.hdDeviceSettings(model.hdDeviceSettings);
            this.inputDeviceId(model.inputDeviceId);
            this.name(model.name);
            this.uhdDeviceSettings(model.uhdDeviceSettings);
        }

        public final InputDeviceConfigurableSettings.Builder getHdDeviceSettings() {
            return this.hdDeviceSettings != null ? this.hdDeviceSettings.toBuilder() : null;
        }

        @Override
        public final Builder hdDeviceSettings(InputDeviceConfigurableSettings hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings;
            return this;
        }

        public final void setHdDeviceSettings(InputDeviceConfigurableSettings.BuilderImpl hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings != null ? hdDeviceSettings.build() : null;
        }

        public final String getInputDeviceId() {
            return this.inputDeviceId;
        }

        @Override
        public final Builder inputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
            return this;
        }

        public final void setInputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final InputDeviceConfigurableSettings.Builder getUhdDeviceSettings() {
            return this.uhdDeviceSettings != null ? this.uhdDeviceSettings.toBuilder() : null;
        }

        @Override
        public final Builder uhdDeviceSettings(InputDeviceConfigurableSettings uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings;
            return this;
        }

        public final void setUhdDeviceSettings(InputDeviceConfigurableSettings.BuilderImpl uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings != null ? uhdDeviceSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputDeviceRequest build() {
            return new UpdateInputDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInputDeviceRequest> {
        public Builder hdDeviceSettings(InputDeviceConfigurableSettings var1);

        default public Builder hdDeviceSettings(Consumer<InputDeviceConfigurableSettings.Builder> hdDeviceSettings) {
            return this.hdDeviceSettings((InputDeviceConfigurableSettings)((InputDeviceConfigurableSettings.Builder)InputDeviceConfigurableSettings.builder().applyMutation(hdDeviceSettings)).build());
        }

        public Builder inputDeviceId(String var1);

        public Builder name(String var1);

        public Builder uhdDeviceSettings(InputDeviceConfigurableSettings var1);

        default public Builder uhdDeviceSettings(Consumer<InputDeviceConfigurableSettings.Builder> uhdDeviceSettings) {
            return this.uhdDeviceSettings((InputDeviceConfigurableSettings)((InputDeviceConfigurableSettings.Builder)InputDeviceConfigurableSettings.builder().applyMutation(uhdDeviceSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

