/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaPackageOutputDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaPackageOutputDestinationSettings> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(MediaPackageOutputDestinationSettings.getter(MediaPackageOutputDestinationSettings::channelId)).setter(MediaPackageOutputDestinationSettings.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelId;

    private MediaPackageOutputDestinationSettings(BuilderImpl builder) {
        this.channelId = builder.channelId;
    }

    public String channelId() {
        return this.channelId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPackageOutputDestinationSettings)) {
            return false;
        }
        MediaPackageOutputDestinationSettings other = (MediaPackageOutputDestinationSettings)obj;
        return Objects.equals(this.channelId(), other.channelId());
    }

    public String toString() {
        return ToString.builder((String)"MediaPackageOutputDestinationSettings").add("ChannelId", (Object)this.channelId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaPackageOutputDestinationSettings, T> g) {
        return obj -> g.apply((MediaPackageOutputDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelId;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPackageOutputDestinationSettings model) {
            this.channelId(model.channelId);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public MediaPackageOutputDestinationSettings build() {
            return new MediaPackageOutputDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaPackageOutputDestinationSettings> {
        public Builder channelId(String var1);
    }
}

