/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AacSettings;
import software.amazon.awssdk.services.medialive.model.Ac3Settings;
import software.amazon.awssdk.services.medialive.model.Eac3Settings;
import software.amazon.awssdk.services.medialive.model.Mp2Settings;
import software.amazon.awssdk.services.medialive.model.PassThroughSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioCodecSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioCodecSettings> {
    private static final SdkField<AacSettings> AAC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AacSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::aacSettings)).setter(AudioCodecSettings.setter(Builder::aacSettings)).constructor(AacSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aacSettings").build()}).build();
    private static final SdkField<Ac3Settings> AC3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ac3Settings").getter(AudioCodecSettings.getter(AudioCodecSettings::ac3Settings)).setter(AudioCodecSettings.setter(Builder::ac3Settings)).constructor(Ac3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ac3Settings").build()}).build();
    private static final SdkField<Eac3Settings> EAC3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Eac3Settings").getter(AudioCodecSettings.getter(AudioCodecSettings::eac3Settings)).setter(AudioCodecSettings.setter(Builder::eac3Settings)).constructor(Eac3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eac3Settings").build()}).build();
    private static final SdkField<Mp2Settings> MP2_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mp2Settings").getter(AudioCodecSettings.getter(AudioCodecSettings::mp2Settings)).setter(AudioCodecSettings.setter(Builder::mp2Settings)).constructor(Mp2Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp2Settings").build()}).build();
    private static final SdkField<PassThroughSettings> PASS_THROUGH_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PassThroughSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::passThroughSettings)).setter(AudioCodecSettings.setter(Builder::passThroughSettings)).constructor(PassThroughSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passThroughSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AAC_SETTINGS_FIELD, AC3_SETTINGS_FIELD, EAC3_SETTINGS_FIELD, MP2_SETTINGS_FIELD, PASS_THROUGH_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AacSettings aacSettings;
    private final Ac3Settings ac3Settings;
    private final Eac3Settings eac3Settings;
    private final Mp2Settings mp2Settings;
    private final PassThroughSettings passThroughSettings;

    private AudioCodecSettings(BuilderImpl builder) {
        this.aacSettings = builder.aacSettings;
        this.ac3Settings = builder.ac3Settings;
        this.eac3Settings = builder.eac3Settings;
        this.mp2Settings = builder.mp2Settings;
        this.passThroughSettings = builder.passThroughSettings;
    }

    public AacSettings aacSettings() {
        return this.aacSettings;
    }

    public Ac3Settings ac3Settings() {
        return this.ac3Settings;
    }

    public Eac3Settings eac3Settings() {
        return this.eac3Settings;
    }

    public Mp2Settings mp2Settings() {
        return this.mp2Settings;
    }

    public PassThroughSettings passThroughSettings() {
        return this.passThroughSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aacSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.eac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.passThroughSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioCodecSettings)) {
            return false;
        }
        AudioCodecSettings other = (AudioCodecSettings)obj;
        return Objects.equals(this.aacSettings(), other.aacSettings()) && Objects.equals(this.ac3Settings(), other.ac3Settings()) && Objects.equals(this.eac3Settings(), other.eac3Settings()) && Objects.equals(this.mp2Settings(), other.mp2Settings()) && Objects.equals(this.passThroughSettings(), other.passThroughSettings());
    }

    public String toString() {
        return ToString.builder((String)"AudioCodecSettings").add("AacSettings", (Object)this.aacSettings()).add("Ac3Settings", (Object)this.ac3Settings()).add("Eac3Settings", (Object)this.eac3Settings()).add("Mp2Settings", (Object)this.mp2Settings()).add("PassThroughSettings", (Object)this.passThroughSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AacSettings": {
                return Optional.ofNullable(clazz.cast(this.aacSettings()));
            }
            case "Ac3Settings": {
                return Optional.ofNullable(clazz.cast(this.ac3Settings()));
            }
            case "Eac3Settings": {
                return Optional.ofNullable(clazz.cast(this.eac3Settings()));
            }
            case "Mp2Settings": {
                return Optional.ofNullable(clazz.cast(this.mp2Settings()));
            }
            case "PassThroughSettings": {
                return Optional.ofNullable(clazz.cast(this.passThroughSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioCodecSettings, T> g) {
        return obj -> g.apply((AudioCodecSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AacSettings aacSettings;
        private Ac3Settings ac3Settings;
        private Eac3Settings eac3Settings;
        private Mp2Settings mp2Settings;
        private PassThroughSettings passThroughSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioCodecSettings model) {
            this.aacSettings(model.aacSettings);
            this.ac3Settings(model.ac3Settings);
            this.eac3Settings(model.eac3Settings);
            this.mp2Settings(model.mp2Settings);
            this.passThroughSettings(model.passThroughSettings);
        }

        public final AacSettings.Builder getAacSettings() {
            return this.aacSettings != null ? this.aacSettings.toBuilder() : null;
        }

        @Override
        public final Builder aacSettings(AacSettings aacSettings) {
            this.aacSettings = aacSettings;
            return this;
        }

        public final void setAacSettings(AacSettings.BuilderImpl aacSettings) {
            this.aacSettings = aacSettings != null ? aacSettings.build() : null;
        }

        public final Ac3Settings.Builder getAc3Settings() {
            return this.ac3Settings != null ? this.ac3Settings.toBuilder() : null;
        }

        @Override
        public final Builder ac3Settings(Ac3Settings ac3Settings) {
            this.ac3Settings = ac3Settings;
            return this;
        }

        public final void setAc3Settings(Ac3Settings.BuilderImpl ac3Settings) {
            this.ac3Settings = ac3Settings != null ? ac3Settings.build() : null;
        }

        public final Eac3Settings.Builder getEac3Settings() {
            return this.eac3Settings != null ? this.eac3Settings.toBuilder() : null;
        }

        @Override
        public final Builder eac3Settings(Eac3Settings eac3Settings) {
            this.eac3Settings = eac3Settings;
            return this;
        }

        public final void setEac3Settings(Eac3Settings.BuilderImpl eac3Settings) {
            this.eac3Settings = eac3Settings != null ? eac3Settings.build() : null;
        }

        public final Mp2Settings.Builder getMp2Settings() {
            return this.mp2Settings != null ? this.mp2Settings.toBuilder() : null;
        }

        @Override
        public final Builder mp2Settings(Mp2Settings mp2Settings) {
            this.mp2Settings = mp2Settings;
            return this;
        }

        public final void setMp2Settings(Mp2Settings.BuilderImpl mp2Settings) {
            this.mp2Settings = mp2Settings != null ? mp2Settings.build() : null;
        }

        public final PassThroughSettings.Builder getPassThroughSettings() {
            return this.passThroughSettings != null ? this.passThroughSettings.toBuilder() : null;
        }

        @Override
        public final Builder passThroughSettings(PassThroughSettings passThroughSettings) {
            this.passThroughSettings = passThroughSettings;
            return this;
        }

        public final void setPassThroughSettings(PassThroughSettings.BuilderImpl passThroughSettings) {
            this.passThroughSettings = passThroughSettings != null ? passThroughSettings.build() : null;
        }

        public AudioCodecSettings build() {
            return new AudioCodecSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioCodecSettings> {
        public Builder aacSettings(AacSettings var1);

        default public Builder aacSettings(Consumer<AacSettings.Builder> aacSettings) {
            return this.aacSettings((AacSettings)((AacSettings.Builder)AacSettings.builder().applyMutation(aacSettings)).build());
        }

        public Builder ac3Settings(Ac3Settings var1);

        default public Builder ac3Settings(Consumer<Ac3Settings.Builder> ac3Settings) {
            return this.ac3Settings((Ac3Settings)((Ac3Settings.Builder)Ac3Settings.builder().applyMutation(ac3Settings)).build());
        }

        public Builder eac3Settings(Eac3Settings var1);

        default public Builder eac3Settings(Consumer<Eac3Settings.Builder> eac3Settings) {
            return this.eac3Settings((Eac3Settings)((Eac3Settings.Builder)Eac3Settings.builder().applyMutation(eac3Settings)).build());
        }

        public Builder mp2Settings(Mp2Settings var1);

        default public Builder mp2Settings(Consumer<Mp2Settings.Builder> mp2Settings) {
            return this.mp2Settings((Mp2Settings)((Mp2Settings.Builder)Mp2Settings.builder().applyMutation(mp2Settings)).build());
        }

        public Builder passThroughSettings(PassThroughSettings var1);

        default public Builder passThroughSettings(Consumer<PassThroughSettings.Builder> passThroughSettings) {
            return this.passThroughSettings((PassThroughSettings)((PassThroughSettings.Builder)PassThroughSettings.builder().applyMutation(passThroughSettings)).build());
        }
    }
}

