/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramPacketIdentifiersMap;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteMultiplexProgramResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DeleteMultiplexProgramResponse> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(DeleteMultiplexProgramResponse.getter(DeleteMultiplexProgramResponse::channelId)).setter(DeleteMultiplexProgramResponse.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<MultiplexProgramSettings> MULTIPLEX_PROGRAM_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexProgramSettings").getter(DeleteMultiplexProgramResponse.getter(DeleteMultiplexProgramResponse::multiplexProgramSettings)).setter(DeleteMultiplexProgramResponse.setter(Builder::multiplexProgramSettings)).constructor(MultiplexProgramSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexProgramSettings").build()}).build();
    private static final SdkField<MultiplexProgramPacketIdentifiersMap> PACKET_IDENTIFIERS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PacketIdentifiersMap").getter(DeleteMultiplexProgramResponse.getter(DeleteMultiplexProgramResponse::packetIdentifiersMap)).setter(DeleteMultiplexProgramResponse.setter(Builder::packetIdentifiersMap)).constructor(MultiplexProgramPacketIdentifiersMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetIdentifiersMap").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(DeleteMultiplexProgramResponse.getter(DeleteMultiplexProgramResponse::programName)).setter(DeleteMultiplexProgramResponse.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, MULTIPLEX_PROGRAM_SETTINGS_FIELD, PACKET_IDENTIFIERS_MAP_FIELD, PROGRAM_NAME_FIELD));
    private final String channelId;
    private final MultiplexProgramSettings multiplexProgramSettings;
    private final MultiplexProgramPacketIdentifiersMap packetIdentifiersMap;
    private final String programName;

    private DeleteMultiplexProgramResponse(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.multiplexProgramSettings = builder.multiplexProgramSettings;
        this.packetIdentifiersMap = builder.packetIdentifiersMap;
        this.programName = builder.programName;
    }

    public String channelId() {
        return this.channelId;
    }

    public MultiplexProgramSettings multiplexProgramSettings() {
        return this.multiplexProgramSettings;
    }

    public MultiplexProgramPacketIdentifiersMap packetIdentifiersMap() {
        return this.packetIdentifiersMap;
    }

    public String programName() {
        return this.programName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexProgramSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetIdentifiersMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMultiplexProgramResponse)) {
            return false;
        }
        DeleteMultiplexProgramResponse other = (DeleteMultiplexProgramResponse)((Object)obj);
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.multiplexProgramSettings(), other.multiplexProgramSettings()) && Objects.equals(this.packetIdentifiersMap(), other.packetIdentifiersMap()) && Objects.equals(this.programName(), other.programName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteMultiplexProgramResponse").add("ChannelId", (Object)this.channelId()).add("MultiplexProgramSettings", (Object)this.multiplexProgramSettings()).add("PacketIdentifiersMap", (Object)this.packetIdentifiersMap()).add("ProgramName", (Object)this.programName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "MultiplexProgramSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexProgramSettings()));
            }
            case "PacketIdentifiersMap": {
                return Optional.ofNullable(clazz.cast(this.packetIdentifiersMap()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMultiplexProgramResponse, T> g) {
        return obj -> g.apply((DeleteMultiplexProgramResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String channelId;
        private MultiplexProgramSettings multiplexProgramSettings;
        private MultiplexProgramPacketIdentifiersMap packetIdentifiersMap;
        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMultiplexProgramResponse model) {
            super(model);
            this.channelId(model.channelId);
            this.multiplexProgramSettings(model.multiplexProgramSettings);
            this.packetIdentifiersMap(model.packetIdentifiersMap);
            this.programName(model.programName);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final MultiplexProgramSettings.Builder getMultiplexProgramSettings() {
            return this.multiplexProgramSettings != null ? this.multiplexProgramSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        public final void setMultiplexProgramSettings(MultiplexProgramSettings.BuilderImpl multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings != null ? multiplexProgramSettings.build() : null;
        }

        public final MultiplexProgramPacketIdentifiersMap.Builder getPacketIdentifiersMap() {
            return this.packetIdentifiersMap != null ? this.packetIdentifiersMap.toBuilder() : null;
        }

        @Override
        public final Builder packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap;
            return this;
        }

        public final void setPacketIdentifiersMap(MultiplexProgramPacketIdentifiersMap.BuilderImpl packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap != null ? packetIdentifiersMap.build() : null;
        }

        public final String getProgramName() {
            return this.programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public DeleteMultiplexProgramResponse build() {
            return new DeleteMultiplexProgramResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteMultiplexProgramResponse> {
        public Builder channelId(String var1);

        public Builder multiplexProgramSettings(MultiplexProgramSettings var1);

        default public Builder multiplexProgramSettings(Consumer<MultiplexProgramSettings.Builder> multiplexProgramSettings) {
            return this.multiplexProgramSettings((MultiplexProgramSettings)((MultiplexProgramSettings.Builder)MultiplexProgramSettings.builder().applyMutation(multiplexProgramSettings)).build());
        }

        public Builder packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap var1);

        default public Builder packetIdentifiersMap(Consumer<MultiplexProgramPacketIdentifiersMap.Builder> packetIdentifiersMap) {
            return this.packetIdentifiersMap((MultiplexProgramPacketIdentifiersMap)((MultiplexProgramPacketIdentifiersMap.Builder)MultiplexProgramPacketIdentifiersMap.builder().applyMutation(packetIdentifiersMap)).build());
        }

        public Builder programName(String var1);
    }
}

