/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AudioSelector;
import software.amazon.awssdk.services.medialive.model.CaptionSelector;
import software.amazon.awssdk.services.medialive.model.InputDeblockFilter;
import software.amazon.awssdk.services.medialive.model.InputDenoiseFilter;
import software.amazon.awssdk.services.medialive.model.InputFilter;
import software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior;
import software.amazon.awssdk.services.medialive.model.NetworkInputSettings;
import software.amazon.awssdk.services.medialive.model.Smpte2038DataPreference;
import software.amazon.awssdk.services.medialive.model.VideoSelector;
import software.amazon.awssdk.services.medialive.model.___listOfAudioSelectorCopier;
import software.amazon.awssdk.services.medialive.model.___listOfCaptionSelectorCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputSettings> {
    private static final SdkField<List<AudioSelector>> AUDIO_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioSelectors").getter(InputSettings.getter(InputSettings::audioSelectors)).setter(InputSettings.setter(Builder::audioSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CaptionSelector>> CAPTION_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptionSelectors").getter(InputSettings.getter(InputSettings::captionSelectors)).setter(InputSettings.setter(Builder::captionSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEBLOCK_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeblockFilter").getter(InputSettings.getter(InputSettings::deblockFilterAsString)).setter(InputSettings.setter(Builder::deblockFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deblockFilter").build()}).build();
    private static final SdkField<String> DENOISE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DenoiseFilter").getter(InputSettings.getter(InputSettings::denoiseFilterAsString)).setter(InputSettings.setter(Builder::denoiseFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denoiseFilter").build()}).build();
    private static final SdkField<Integer> FILTER_STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FilterStrength").getter(InputSettings.getter(InputSettings::filterStrength)).setter(InputSettings.setter(Builder::filterStrength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterStrength").build()}).build();
    private static final SdkField<String> INPUT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFilter").getter(InputSettings.getter(InputSettings::inputFilterAsString)).setter(InputSettings.setter(Builder::inputFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFilter").build()}).build();
    private static final SdkField<NetworkInputSettings> NETWORK_INPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInputSettings").getter(InputSettings.getter(InputSettings::networkInputSettings)).setter(InputSettings.setter(Builder::networkInputSettings)).constructor(NetworkInputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInputSettings").build()}).build();
    private static final SdkField<String> SMPTE2038_DATA_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Smpte2038DataPreference").getter(InputSettings.getter(InputSettings::smpte2038DataPreferenceAsString)).setter(InputSettings.setter(Builder::smpte2038DataPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smpte2038DataPreference").build()}).build();
    private static final SdkField<String> SOURCE_END_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEndBehavior").getter(InputSettings.getter(InputSettings::sourceEndBehaviorAsString)).setter(InputSettings.setter(Builder::sourceEndBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEndBehavior").build()}).build();
    private static final SdkField<VideoSelector> VIDEO_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoSelector").getter(InputSettings.getter(InputSettings::videoSelector)).setter(InputSettings.setter(Builder::videoSelector)).constructor(VideoSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSelector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SELECTORS_FIELD, CAPTION_SELECTORS_FIELD, DEBLOCK_FILTER_FIELD, DENOISE_FILTER_FIELD, FILTER_STRENGTH_FIELD, INPUT_FILTER_FIELD, NETWORK_INPUT_SETTINGS_FIELD, SMPTE2038_DATA_PREFERENCE_FIELD, SOURCE_END_BEHAVIOR_FIELD, VIDEO_SELECTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AudioSelector> audioSelectors;
    private final List<CaptionSelector> captionSelectors;
    private final String deblockFilter;
    private final String denoiseFilter;
    private final Integer filterStrength;
    private final String inputFilter;
    private final NetworkInputSettings networkInputSettings;
    private final String smpte2038DataPreference;
    private final String sourceEndBehavior;
    private final VideoSelector videoSelector;

    private InputSettings(BuilderImpl builder) {
        this.audioSelectors = builder.audioSelectors;
        this.captionSelectors = builder.captionSelectors;
        this.deblockFilter = builder.deblockFilter;
        this.denoiseFilter = builder.denoiseFilter;
        this.filterStrength = builder.filterStrength;
        this.inputFilter = builder.inputFilter;
        this.networkInputSettings = builder.networkInputSettings;
        this.smpte2038DataPreference = builder.smpte2038DataPreference;
        this.sourceEndBehavior = builder.sourceEndBehavior;
        this.videoSelector = builder.videoSelector;
    }

    public boolean hasAudioSelectors() {
        return this.audioSelectors != null && !(this.audioSelectors instanceof SdkAutoConstructList);
    }

    public List<AudioSelector> audioSelectors() {
        return this.audioSelectors;
    }

    public boolean hasCaptionSelectors() {
        return this.captionSelectors != null && !(this.captionSelectors instanceof SdkAutoConstructList);
    }

    public List<CaptionSelector> captionSelectors() {
        return this.captionSelectors;
    }

    public InputDeblockFilter deblockFilter() {
        return InputDeblockFilter.fromValue(this.deblockFilter);
    }

    public String deblockFilterAsString() {
        return this.deblockFilter;
    }

    public InputDenoiseFilter denoiseFilter() {
        return InputDenoiseFilter.fromValue(this.denoiseFilter);
    }

    public String denoiseFilterAsString() {
        return this.denoiseFilter;
    }

    public Integer filterStrength() {
        return this.filterStrength;
    }

    public InputFilter inputFilter() {
        return InputFilter.fromValue(this.inputFilter);
    }

    public String inputFilterAsString() {
        return this.inputFilter;
    }

    public NetworkInputSettings networkInputSettings() {
        return this.networkInputSettings;
    }

    public Smpte2038DataPreference smpte2038DataPreference() {
        return Smpte2038DataPreference.fromValue(this.smpte2038DataPreference);
    }

    public String smpte2038DataPreferenceAsString() {
        return this.smpte2038DataPreference;
    }

    public InputSourceEndBehavior sourceEndBehavior() {
        return InputSourceEndBehavior.fromValue(this.sourceEndBehavior);
    }

    public String sourceEndBehaviorAsString() {
        return this.sourceEndBehavior;
    }

    public VideoSelector videoSelector() {
        return this.videoSelector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioSelectors() ? this.audioSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptionSelectors() ? this.captionSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deblockFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.denoiseFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterStrength());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.smpte2038DataPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSelector());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSettings)) {
            return false;
        }
        InputSettings other = (InputSettings)obj;
        return this.hasAudioSelectors() == other.hasAudioSelectors() && Objects.equals(this.audioSelectors(), other.audioSelectors()) && this.hasCaptionSelectors() == other.hasCaptionSelectors() && Objects.equals(this.captionSelectors(), other.captionSelectors()) && Objects.equals(this.deblockFilterAsString(), other.deblockFilterAsString()) && Objects.equals(this.denoiseFilterAsString(), other.denoiseFilterAsString()) && Objects.equals(this.filterStrength(), other.filterStrength()) && Objects.equals(this.inputFilterAsString(), other.inputFilterAsString()) && Objects.equals(this.networkInputSettings(), other.networkInputSettings()) && Objects.equals(this.smpte2038DataPreferenceAsString(), other.smpte2038DataPreferenceAsString()) && Objects.equals(this.sourceEndBehaviorAsString(), other.sourceEndBehaviorAsString()) && Objects.equals(this.videoSelector(), other.videoSelector());
    }

    public String toString() {
        return ToString.builder((String)"InputSettings").add("AudioSelectors", this.hasAudioSelectors() ? this.audioSelectors() : null).add("CaptionSelectors", this.hasCaptionSelectors() ? this.captionSelectors() : null).add("DeblockFilter", (Object)this.deblockFilterAsString()).add("DenoiseFilter", (Object)this.denoiseFilterAsString()).add("FilterStrength", (Object)this.filterStrength()).add("InputFilter", (Object)this.inputFilterAsString()).add("NetworkInputSettings", (Object)this.networkInputSettings()).add("Smpte2038DataPreference", (Object)this.smpte2038DataPreferenceAsString()).add("SourceEndBehavior", (Object)this.sourceEndBehaviorAsString()).add("VideoSelector", (Object)this.videoSelector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioSelectors": {
                return Optional.ofNullable(clazz.cast(this.audioSelectors()));
            }
            case "CaptionSelectors": {
                return Optional.ofNullable(clazz.cast(this.captionSelectors()));
            }
            case "DeblockFilter": {
                return Optional.ofNullable(clazz.cast(this.deblockFilterAsString()));
            }
            case "DenoiseFilter": {
                return Optional.ofNullable(clazz.cast(this.denoiseFilterAsString()));
            }
            case "FilterStrength": {
                return Optional.ofNullable(clazz.cast(this.filterStrength()));
            }
            case "InputFilter": {
                return Optional.ofNullable(clazz.cast(this.inputFilterAsString()));
            }
            case "NetworkInputSettings": {
                return Optional.ofNullable(clazz.cast(this.networkInputSettings()));
            }
            case "Smpte2038DataPreference": {
                return Optional.ofNullable(clazz.cast(this.smpte2038DataPreferenceAsString()));
            }
            case "SourceEndBehavior": {
                return Optional.ofNullable(clazz.cast(this.sourceEndBehaviorAsString()));
            }
            case "VideoSelector": {
                return Optional.ofNullable(clazz.cast(this.videoSelector()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputSettings, T> g) {
        return obj -> g.apply((InputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioSelector> audioSelectors = DefaultSdkAutoConstructList.getInstance();
        private List<CaptionSelector> captionSelectors = DefaultSdkAutoConstructList.getInstance();
        private String deblockFilter;
        private String denoiseFilter;
        private Integer filterStrength;
        private String inputFilter;
        private NetworkInputSettings networkInputSettings;
        private String smpte2038DataPreference;
        private String sourceEndBehavior;
        private VideoSelector videoSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSettings model) {
            this.audioSelectors(model.audioSelectors);
            this.captionSelectors(model.captionSelectors);
            this.deblockFilter(model.deblockFilter);
            this.denoiseFilter(model.denoiseFilter);
            this.filterStrength(model.filterStrength);
            this.inputFilter(model.inputFilter);
            this.networkInputSettings(model.networkInputSettings);
            this.smpte2038DataPreference(model.smpte2038DataPreference);
            this.sourceEndBehavior(model.sourceEndBehavior);
            this.videoSelector(model.videoSelector);
        }

        public final Collection<AudioSelector.Builder> getAudioSelectors() {
            if (this.audioSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audioSelectors != null ? (Collection)this.audioSelectors.stream().map(AudioSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioSelectors(Collection<AudioSelector> audioSelectors) {
            this.audioSelectors = ___listOfAudioSelectorCopier.copy(audioSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioSelectors(AudioSelector ... audioSelectors) {
            this.audioSelectors(Arrays.asList(audioSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioSelectors(Consumer<AudioSelector.Builder> ... audioSelectors) {
            this.audioSelectors(Stream.of(audioSelectors).map(c -> (AudioSelector)((AudioSelector.Builder)AudioSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioSelectors(Collection<AudioSelector.BuilderImpl> audioSelectors) {
            this.audioSelectors = ___listOfAudioSelectorCopier.copyFromBuilder(audioSelectors);
        }

        public final Collection<CaptionSelector.Builder> getCaptionSelectors() {
            if (this.captionSelectors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.captionSelectors != null ? (Collection)this.captionSelectors.stream().map(CaptionSelector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionSelectors(Collection<CaptionSelector> captionSelectors) {
            this.captionSelectors = ___listOfCaptionSelectorCopier.copy(captionSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSelectors(CaptionSelector ... captionSelectors) {
            this.captionSelectors(Arrays.asList(captionSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSelectors(Consumer<CaptionSelector.Builder> ... captionSelectors) {
            this.captionSelectors(Stream.of(captionSelectors).map(c -> (CaptionSelector)((CaptionSelector.Builder)CaptionSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionSelectors(Collection<CaptionSelector.BuilderImpl> captionSelectors) {
            this.captionSelectors = ___listOfCaptionSelectorCopier.copyFromBuilder(captionSelectors);
        }

        public final String getDeblockFilter() {
            return this.deblockFilter;
        }

        @Override
        public final Builder deblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
            return this;
        }

        @Override
        public final Builder deblockFilter(InputDeblockFilter deblockFilter) {
            this.deblockFilter(deblockFilter == null ? null : deblockFilter.toString());
            return this;
        }

        public final void setDeblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
        }

        public final String getDenoiseFilter() {
            return this.denoiseFilter;
        }

        @Override
        public final Builder denoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
            return this;
        }

        @Override
        public final Builder denoiseFilter(InputDenoiseFilter denoiseFilter) {
            this.denoiseFilter(denoiseFilter == null ? null : denoiseFilter.toString());
            return this;
        }

        public final void setDenoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
        }

        public final Integer getFilterStrength() {
            return this.filterStrength;
        }

        @Override
        public final Builder filterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        public final void setFilterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
        }

        public final String getInputFilter() {
            return this.inputFilter;
        }

        @Override
        public final Builder inputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
            return this;
        }

        @Override
        public final Builder inputFilter(InputFilter inputFilter) {
            this.inputFilter(inputFilter == null ? null : inputFilter.toString());
            return this;
        }

        public final void setInputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
        }

        public final NetworkInputSettings.Builder getNetworkInputSettings() {
            return this.networkInputSettings != null ? this.networkInputSettings.toBuilder() : null;
        }

        @Override
        public final Builder networkInputSettings(NetworkInputSettings networkInputSettings) {
            this.networkInputSettings = networkInputSettings;
            return this;
        }

        public final void setNetworkInputSettings(NetworkInputSettings.BuilderImpl networkInputSettings) {
            this.networkInputSettings = networkInputSettings != null ? networkInputSettings.build() : null;
        }

        public final String getSmpte2038DataPreference() {
            return this.smpte2038DataPreference;
        }

        @Override
        public final Builder smpte2038DataPreference(String smpte2038DataPreference) {
            this.smpte2038DataPreference = smpte2038DataPreference;
            return this;
        }

        @Override
        public final Builder smpte2038DataPreference(Smpte2038DataPreference smpte2038DataPreference) {
            this.smpte2038DataPreference(smpte2038DataPreference == null ? null : smpte2038DataPreference.toString());
            return this;
        }

        public final void setSmpte2038DataPreference(String smpte2038DataPreference) {
            this.smpte2038DataPreference = smpte2038DataPreference;
        }

        public final String getSourceEndBehavior() {
            return this.sourceEndBehavior;
        }

        @Override
        public final Builder sourceEndBehavior(String sourceEndBehavior) {
            this.sourceEndBehavior = sourceEndBehavior;
            return this;
        }

        @Override
        public final Builder sourceEndBehavior(InputSourceEndBehavior sourceEndBehavior) {
            this.sourceEndBehavior(sourceEndBehavior == null ? null : sourceEndBehavior.toString());
            return this;
        }

        public final void setSourceEndBehavior(String sourceEndBehavior) {
            this.sourceEndBehavior = sourceEndBehavior;
        }

        public final VideoSelector.Builder getVideoSelector() {
            return this.videoSelector != null ? this.videoSelector.toBuilder() : null;
        }

        @Override
        public final Builder videoSelector(VideoSelector videoSelector) {
            this.videoSelector = videoSelector;
            return this;
        }

        public final void setVideoSelector(VideoSelector.BuilderImpl videoSelector) {
            this.videoSelector = videoSelector != null ? videoSelector.build() : null;
        }

        public InputSettings build() {
            return new InputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputSettings> {
        public Builder audioSelectors(Collection<AudioSelector> var1);

        public Builder audioSelectors(AudioSelector ... var1);

        public Builder audioSelectors(Consumer<AudioSelector.Builder> ... var1);

        public Builder captionSelectors(Collection<CaptionSelector> var1);

        public Builder captionSelectors(CaptionSelector ... var1);

        public Builder captionSelectors(Consumer<CaptionSelector.Builder> ... var1);

        public Builder deblockFilter(String var1);

        public Builder deblockFilter(InputDeblockFilter var1);

        public Builder denoiseFilter(String var1);

        public Builder denoiseFilter(InputDenoiseFilter var1);

        public Builder filterStrength(Integer var1);

        public Builder inputFilter(String var1);

        public Builder inputFilter(InputFilter var1);

        public Builder networkInputSettings(NetworkInputSettings var1);

        default public Builder networkInputSettings(Consumer<NetworkInputSettings.Builder> networkInputSettings) {
            return this.networkInputSettings((NetworkInputSettings)((NetworkInputSettings.Builder)NetworkInputSettings.builder().applyMutation(networkInputSettings)).build());
        }

        public Builder smpte2038DataPreference(String var1);

        public Builder smpte2038DataPreference(Smpte2038DataPreference var1);

        public Builder sourceEndBehavior(String var1);

        public Builder sourceEndBehavior(InputSourceEndBehavior var1);

        public Builder videoSelector(VideoSelector var1);

        default public Builder videoSelector(Consumer<VideoSelector.Builder> videoSelector) {
            return this.videoSelector((VideoSelector)((VideoSelector.Builder)VideoSelector.builder().applyMutation(videoSelector)).build());
        }
    }
}

