/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDeviceConfigurableSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDeviceConfigurableSettings> {
    private static final SdkField<String> CONFIGURED_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::configuredInputAsString)).setter(InputDeviceConfigurableSettings.setter(Builder::configuredInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredInput").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::maxBitrate)).setter(InputDeviceConfigurableSettings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_INPUT_FIELD, MAX_BITRATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configuredInput;
    private final Integer maxBitrate;

    private InputDeviceConfigurableSettings(BuilderImpl builder) {
        this.configuredInput = builder.configuredInput;
        this.maxBitrate = builder.maxBitrate;
    }

    public InputDeviceConfiguredInput configuredInput() {
        return InputDeviceConfiguredInput.fromValue(this.configuredInput);
    }

    public String configuredInputAsString() {
        return this.configuredInput;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceConfigurableSettings)) {
            return false;
        }
        InputDeviceConfigurableSettings other = (InputDeviceConfigurableSettings)obj;
        return Objects.equals(this.configuredInputAsString(), other.configuredInputAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate());
    }

    public String toString() {
        return ToString.builder((String)"InputDeviceConfigurableSettings").add("ConfiguredInput", (Object)this.configuredInputAsString()).add("MaxBitrate", (Object)this.maxBitrate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfiguredInput": {
                return Optional.ofNullable(clazz.cast(this.configuredInputAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceConfigurableSettings, T> g) {
        return obj -> g.apply((InputDeviceConfigurableSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configuredInput;
        private Integer maxBitrate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceConfigurableSettings model) {
            this.configuredInput(model.configuredInput);
            this.maxBitrate(model.maxBitrate);
        }

        public final String getConfiguredInput() {
            return this.configuredInput;
        }

        @Override
        public final Builder configuredInput(String configuredInput) {
            this.configuredInput = configuredInput;
            return this;
        }

        @Override
        public final Builder configuredInput(InputDeviceConfiguredInput configuredInput) {
            this.configuredInput(configuredInput == null ? null : configuredInput.toString());
            return this;
        }

        public final void setConfiguredInput(String configuredInput) {
            this.configuredInput = configuredInput;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public InputDeviceConfigurableSettings build() {
            return new InputDeviceConfigurableSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDeviceConfigurableSettings> {
        public Builder configuredInput(String var1);

        public Builder configuredInput(InputDeviceConfiguredInput var1);

        public Builder maxBitrate(Integer var1);
    }
}

