/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction;
import software.amazon.awssdk.services.medialive.model.GlobalConfigurationLowFramerateInputs;
import software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputLockingMode;
import software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource;
import software.amazon.awssdk.services.medialive.model.InputLossBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalConfiguration> {
    private static final SdkField<Integer> INITIAL_AUDIO_GAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GlobalConfiguration.getter(GlobalConfiguration::initialAudioGain)).setter(GlobalConfiguration.setter(Builder::initialAudioGain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialAudioGain").build()}).build();
    private static final SdkField<String> INPUT_END_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GlobalConfiguration.getter(GlobalConfiguration::inputEndActionAsString)).setter(GlobalConfiguration.setter(Builder::inputEndAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputEndAction").build()}).build();
    private static final SdkField<InputLossBehavior> INPUT_LOSS_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GlobalConfiguration.getter(GlobalConfiguration::inputLossBehavior)).setter(GlobalConfiguration.setter(Builder::inputLossBehavior)).constructor(InputLossBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossBehavior").build()}).build();
    private static final SdkField<String> OUTPUT_LOCKING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GlobalConfiguration.getter(GlobalConfiguration::outputLockingModeAsString)).setter(GlobalConfiguration.setter(Builder::outputLockingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLockingMode").build()}).build();
    private static final SdkField<String> OUTPUT_TIMING_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GlobalConfiguration.getter(GlobalConfiguration::outputTimingSourceAsString)).setter(GlobalConfiguration.setter(Builder::outputTimingSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputTimingSource").build()}).build();
    private static final SdkField<String> SUPPORT_LOW_FRAMERATE_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GlobalConfiguration.getter(GlobalConfiguration::supportLowFramerateInputsAsString)).setter(GlobalConfiguration.setter(Builder::supportLowFramerateInputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportLowFramerateInputs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_AUDIO_GAIN_FIELD, INPUT_END_ACTION_FIELD, INPUT_LOSS_BEHAVIOR_FIELD, OUTPUT_LOCKING_MODE_FIELD, OUTPUT_TIMING_SOURCE_FIELD, SUPPORT_LOW_FRAMERATE_INPUTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer initialAudioGain;
    private final String inputEndAction;
    private final InputLossBehavior inputLossBehavior;
    private final String outputLockingMode;
    private final String outputTimingSource;
    private final String supportLowFramerateInputs;

    private GlobalConfiguration(BuilderImpl builder) {
        this.initialAudioGain = builder.initialAudioGain;
        this.inputEndAction = builder.inputEndAction;
        this.inputLossBehavior = builder.inputLossBehavior;
        this.outputLockingMode = builder.outputLockingMode;
        this.outputTimingSource = builder.outputTimingSource;
        this.supportLowFramerateInputs = builder.supportLowFramerateInputs;
    }

    public Integer initialAudioGain() {
        return this.initialAudioGain;
    }

    public GlobalConfigurationInputEndAction inputEndAction() {
        return GlobalConfigurationInputEndAction.fromValue(this.inputEndAction);
    }

    public String inputEndActionAsString() {
        return this.inputEndAction;
    }

    public InputLossBehavior inputLossBehavior() {
        return this.inputLossBehavior;
    }

    public GlobalConfigurationOutputLockingMode outputLockingMode() {
        return GlobalConfigurationOutputLockingMode.fromValue(this.outputLockingMode);
    }

    public String outputLockingModeAsString() {
        return this.outputLockingMode;
    }

    public GlobalConfigurationOutputTimingSource outputTimingSource() {
        return GlobalConfigurationOutputTimingSource.fromValue(this.outputTimingSource);
    }

    public String outputTimingSourceAsString() {
        return this.outputTimingSource;
    }

    public GlobalConfigurationLowFramerateInputs supportLowFramerateInputs() {
        return GlobalConfigurationLowFramerateInputs.fromValue(this.supportLowFramerateInputs);
    }

    public String supportLowFramerateInputsAsString() {
        return this.supportLowFramerateInputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.initialAudioGain());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputEndActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLockingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTimingSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportLowFramerateInputsAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalConfiguration)) {
            return false;
        }
        GlobalConfiguration other = (GlobalConfiguration)obj;
        return Objects.equals(this.initialAudioGain(), other.initialAudioGain()) && Objects.equals(this.inputEndActionAsString(), other.inputEndActionAsString()) && Objects.equals(this.inputLossBehavior(), other.inputLossBehavior()) && Objects.equals(this.outputLockingModeAsString(), other.outputLockingModeAsString()) && Objects.equals(this.outputTimingSourceAsString(), other.outputTimingSourceAsString()) && Objects.equals(this.supportLowFramerateInputsAsString(), other.supportLowFramerateInputsAsString());
    }

    public String toString() {
        return ToString.builder((String)"GlobalConfiguration").add("InitialAudioGain", (Object)this.initialAudioGain()).add("InputEndAction", (Object)this.inputEndActionAsString()).add("InputLossBehavior", (Object)this.inputLossBehavior()).add("OutputLockingMode", (Object)this.outputLockingModeAsString()).add("OutputTimingSource", (Object)this.outputTimingSourceAsString()).add("SupportLowFramerateInputs", (Object)this.supportLowFramerateInputsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InitialAudioGain": {
                return Optional.ofNullable(clazz.cast(this.initialAudioGain()));
            }
            case "InputEndAction": {
                return Optional.ofNullable(clazz.cast(this.inputEndActionAsString()));
            }
            case "InputLossBehavior": {
                return Optional.ofNullable(clazz.cast(this.inputLossBehavior()));
            }
            case "OutputLockingMode": {
                return Optional.ofNullable(clazz.cast(this.outputLockingModeAsString()));
            }
            case "OutputTimingSource": {
                return Optional.ofNullable(clazz.cast(this.outputTimingSourceAsString()));
            }
            case "SupportLowFramerateInputs": {
                return Optional.ofNullable(clazz.cast(this.supportLowFramerateInputsAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalConfiguration, T> g) {
        return obj -> g.apply((GlobalConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer initialAudioGain;
        private String inputEndAction;
        private InputLossBehavior inputLossBehavior;
        private String outputLockingMode;
        private String outputTimingSource;
        private String supportLowFramerateInputs;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalConfiguration model) {
            this.initialAudioGain(model.initialAudioGain);
            this.inputEndAction(model.inputEndAction);
            this.inputLossBehavior(model.inputLossBehavior);
            this.outputLockingMode(model.outputLockingMode);
            this.outputTimingSource(model.outputTimingSource);
            this.supportLowFramerateInputs(model.supportLowFramerateInputs);
        }

        public final Integer getInitialAudioGain() {
            return this.initialAudioGain;
        }

        @Override
        public final Builder initialAudioGain(Integer initialAudioGain) {
            this.initialAudioGain = initialAudioGain;
            return this;
        }

        public final void setInitialAudioGain(Integer initialAudioGain) {
            this.initialAudioGain = initialAudioGain;
        }

        public final String getInputEndAction() {
            return this.inputEndAction;
        }

        @Override
        public final Builder inputEndAction(String inputEndAction) {
            this.inputEndAction = inputEndAction;
            return this;
        }

        @Override
        public final Builder inputEndAction(GlobalConfigurationInputEndAction inputEndAction) {
            this.inputEndAction(inputEndAction == null ? null : inputEndAction.toString());
            return this;
        }

        public final void setInputEndAction(String inputEndAction) {
            this.inputEndAction = inputEndAction;
        }

        public final InputLossBehavior.Builder getInputLossBehavior() {
            return this.inputLossBehavior != null ? this.inputLossBehavior.toBuilder() : null;
        }

        @Override
        public final Builder inputLossBehavior(InputLossBehavior inputLossBehavior) {
            this.inputLossBehavior = inputLossBehavior;
            return this;
        }

        public final void setInputLossBehavior(InputLossBehavior.BuilderImpl inputLossBehavior) {
            this.inputLossBehavior = inputLossBehavior != null ? inputLossBehavior.build() : null;
        }

        public final String getOutputLockingMode() {
            return this.outputLockingMode;
        }

        @Override
        public final Builder outputLockingMode(String outputLockingMode) {
            this.outputLockingMode = outputLockingMode;
            return this;
        }

        @Override
        public final Builder outputLockingMode(GlobalConfigurationOutputLockingMode outputLockingMode) {
            this.outputLockingMode(outputLockingMode == null ? null : outputLockingMode.toString());
            return this;
        }

        public final void setOutputLockingMode(String outputLockingMode) {
            this.outputLockingMode = outputLockingMode;
        }

        public final String getOutputTimingSource() {
            return this.outputTimingSource;
        }

        @Override
        public final Builder outputTimingSource(String outputTimingSource) {
            this.outputTimingSource = outputTimingSource;
            return this;
        }

        @Override
        public final Builder outputTimingSource(GlobalConfigurationOutputTimingSource outputTimingSource) {
            this.outputTimingSource(outputTimingSource == null ? null : outputTimingSource.toString());
            return this;
        }

        public final void setOutputTimingSource(String outputTimingSource) {
            this.outputTimingSource = outputTimingSource;
        }

        public final String getSupportLowFramerateInputs() {
            return this.supportLowFramerateInputs;
        }

        @Override
        public final Builder supportLowFramerateInputs(String supportLowFramerateInputs) {
            this.supportLowFramerateInputs = supportLowFramerateInputs;
            return this;
        }

        @Override
        public final Builder supportLowFramerateInputs(GlobalConfigurationLowFramerateInputs supportLowFramerateInputs) {
            this.supportLowFramerateInputs(supportLowFramerateInputs == null ? null : supportLowFramerateInputs.toString());
            return this;
        }

        public final void setSupportLowFramerateInputs(String supportLowFramerateInputs) {
            this.supportLowFramerateInputs = supportLowFramerateInputs;
        }

        public GlobalConfiguration build() {
            return new GlobalConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalConfiguration> {
        public Builder initialAudioGain(Integer var1);

        public Builder inputEndAction(String var1);

        public Builder inputEndAction(GlobalConfigurationInputEndAction var1);

        public Builder inputLossBehavior(InputLossBehavior var1);

        default public Builder inputLossBehavior(Consumer<InputLossBehavior.Builder> inputLossBehavior) {
            return this.inputLossBehavior((InputLossBehavior)((InputLossBehavior.Builder)InputLossBehavior.builder().applyMutation(inputLossBehavior)).build());
        }

        public Builder outputLockingMode(String var1);

        public Builder outputLockingMode(GlobalConfigurationOutputLockingMode var1);

        public Builder outputTimingSource(String var1);

        public Builder outputTimingSource(GlobalConfigurationOutputTimingSource var1);

        public Builder supportLowFramerateInputs(String var1);

        public Builder supportLowFramerateInputs(GlobalConfigurationLowFramerateInputs var1);
    }
}

