/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.HlsInputSettings;
import software.amazon.awssdk.services.medialive.model.NetworkInputServerValidation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInputSettings> {
    private static final SdkField<HlsInputSettings> HLS_INPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NetworkInputSettings.getter(NetworkInputSettings::hlsInputSettings)).setter(NetworkInputSettings.setter(Builder::hlsInputSettings)).constructor(HlsInputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsInputSettings").build()}).build();
    private static final SdkField<String> SERVER_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkInputSettings.getter(NetworkInputSettings::serverValidationAsString)).setter(NetworkInputSettings.setter(Builder::serverValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverValidation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_INPUT_SETTINGS_FIELD, SERVER_VALIDATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final HlsInputSettings hlsInputSettings;
    private final String serverValidation;

    private NetworkInputSettings(BuilderImpl builder) {
        this.hlsInputSettings = builder.hlsInputSettings;
        this.serverValidation = builder.serverValidation;
    }

    public HlsInputSettings hlsInputSettings() {
        return this.hlsInputSettings;
    }

    public NetworkInputServerValidation serverValidation() {
        return NetworkInputServerValidation.fromValue(this.serverValidation);
    }

    public String serverValidationAsString() {
        return this.serverValidation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsInputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverValidationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInputSettings)) {
            return false;
        }
        NetworkInputSettings other = (NetworkInputSettings)obj;
        return Objects.equals(this.hlsInputSettings(), other.hlsInputSettings()) && Objects.equals(this.serverValidationAsString(), other.serverValidationAsString());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInputSettings").add("HlsInputSettings", (Object)this.hlsInputSettings()).add("ServerValidation", (Object)this.serverValidationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HlsInputSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsInputSettings()));
            }
            case "ServerValidation": {
                return Optional.ofNullable(clazz.cast(this.serverValidationAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInputSettings, T> g) {
        return obj -> g.apply((NetworkInputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HlsInputSettings hlsInputSettings;
        private String serverValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInputSettings model) {
            this.hlsInputSettings(model.hlsInputSettings);
            this.serverValidation(model.serverValidation);
        }

        public final HlsInputSettings.Builder getHlsInputSettings() {
            return this.hlsInputSettings != null ? this.hlsInputSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsInputSettings(HlsInputSettings hlsInputSettings) {
            this.hlsInputSettings = hlsInputSettings;
            return this;
        }

        public final void setHlsInputSettings(HlsInputSettings.BuilderImpl hlsInputSettings) {
            this.hlsInputSettings = hlsInputSettings != null ? hlsInputSettings.build() : null;
        }

        public final String getServerValidation() {
            return this.serverValidation;
        }

        @Override
        public final Builder serverValidation(String serverValidation) {
            this.serverValidation = serverValidation;
            return this;
        }

        @Override
        public final Builder serverValidation(NetworkInputServerValidation serverValidation) {
            this.serverValidation(serverValidation == null ? null : serverValidation.toString());
            return this;
        }

        public final void setServerValidation(String serverValidation) {
            this.serverValidation = serverValidation;
        }

        public NetworkInputSettings build() {
            return new NetworkInputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInputSettings> {
        public Builder hlsInputSettings(HlsInputSettings var1);

        default public Builder hlsInputSettings(Consumer<HlsInputSettings.Builder> hlsInputSettings) {
            return this.hlsInputSettings((HlsInputSettings)((HlsInputSettings.Builder)HlsInputSettings.builder().applyMutation(hlsInputSettings)).build());
        }

        public Builder serverValidation(String var1);

        public Builder serverValidation(NetworkInputServerValidation var1);
    }
}

