/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ChannelClass;
import software.amazon.awssdk.services.medialive.model.ReservationCodec;
import software.amazon.awssdk.services.medialive.model.ReservationMaximumBitrate;
import software.amazon.awssdk.services.medialive.model.ReservationMaximumFramerate;
import software.amazon.awssdk.services.medialive.model.ReservationResolution;
import software.amazon.awssdk.services.medialive.model.ReservationResourceType;
import software.amazon.awssdk.services.medialive.model.ReservationSpecialFeature;
import software.amazon.awssdk.services.medialive.model.ReservationVideoQuality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationResourceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationResourceSpecification> {
    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationResourceSpecification.getter(ReservationResourceSpecification::channelClassAsString)).setter(ReservationResourceSpecification.setter(Builder::channelClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationResourceSpecification.getter(ReservationResourceSpecification::codecAsString)).setter(ReservationResourceSpecification.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<String> MAXIMUM_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationResourceSpecification.getter(ReservationResourceSpecification::maximumBitrateAsString)).setter(ReservationResourceSpecification.setter(Builder::maximumBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()}).build();
    private static final SdkField<String> MAXIMUM_FRAMERATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationResourceSpecification.getter(ReservationResourceSpecification::maximumFramerateAsString)).setter(ReservationResourceSpecification.setter(Builder::maximumFramerate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumFramerate").build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationResourceSpecification.getter(ReservationResourceSpecification::resolutionAsString)).setter(ReservationResourceSpecification.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationResourceSpecification.getter(ReservationResourceSpecification::resourceTypeAsString)).setter(ReservationResourceSpecification.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> SPECIAL_FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationResourceSpecification.getter(ReservationResourceSpecification::specialFeatureAsString)).setter(ReservationResourceSpecification.setter(Builder::specialFeature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specialFeature").build()}).build();
    private static final SdkField<String> VIDEO_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservationResourceSpecification.getter(ReservationResourceSpecification::videoQualityAsString)).setter(ReservationResourceSpecification.setter(Builder::videoQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_CLASS_FIELD, CODEC_FIELD, MAXIMUM_BITRATE_FIELD, MAXIMUM_FRAMERATE_FIELD, RESOLUTION_FIELD, RESOURCE_TYPE_FIELD, SPECIAL_FEATURE_FIELD, VIDEO_QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelClass;
    private final String codec;
    private final String maximumBitrate;
    private final String maximumFramerate;
    private final String resolution;
    private final String resourceType;
    private final String specialFeature;
    private final String videoQuality;

    private ReservationResourceSpecification(BuilderImpl builder) {
        this.channelClass = builder.channelClass;
        this.codec = builder.codec;
        this.maximumBitrate = builder.maximumBitrate;
        this.maximumFramerate = builder.maximumFramerate;
        this.resolution = builder.resolution;
        this.resourceType = builder.resourceType;
        this.specialFeature = builder.specialFeature;
        this.videoQuality = builder.videoQuality;
    }

    public ChannelClass channelClass() {
        return ChannelClass.fromValue(this.channelClass);
    }

    public String channelClassAsString() {
        return this.channelClass;
    }

    public ReservationCodec codec() {
        return ReservationCodec.fromValue(this.codec);
    }

    public String codecAsString() {
        return this.codec;
    }

    public ReservationMaximumBitrate maximumBitrate() {
        return ReservationMaximumBitrate.fromValue(this.maximumBitrate);
    }

    public String maximumBitrateAsString() {
        return this.maximumBitrate;
    }

    public ReservationMaximumFramerate maximumFramerate() {
        return ReservationMaximumFramerate.fromValue(this.maximumFramerate);
    }

    public String maximumFramerateAsString() {
        return this.maximumFramerate;
    }

    public ReservationResolution resolution() {
        return ReservationResolution.fromValue(this.resolution);
    }

    public String resolutionAsString() {
        return this.resolution;
    }

    public ReservationResourceType resourceType() {
        return ReservationResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public ReservationSpecialFeature specialFeature() {
        return ReservationSpecialFeature.fromValue(this.specialFeature);
    }

    public String specialFeatureAsString() {
        return this.specialFeature;
    }

    public ReservationVideoQuality videoQuality() {
        return ReservationVideoQuality.fromValue(this.videoQuality);
    }

    public String videoQualityAsString() {
        return this.videoQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBitrateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumFramerateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.specialFeatureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoQualityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationResourceSpecification)) {
            return false;
        }
        ReservationResourceSpecification other = (ReservationResourceSpecification)obj;
        return Objects.equals(this.channelClassAsString(), other.channelClassAsString()) && Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.maximumBitrateAsString(), other.maximumBitrateAsString()) && Objects.equals(this.maximumFramerateAsString(), other.maximumFramerateAsString()) && Objects.equals(this.resolutionAsString(), other.resolutionAsString()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.specialFeatureAsString(), other.specialFeatureAsString()) && Objects.equals(this.videoQualityAsString(), other.videoQualityAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReservationResourceSpecification").add("ChannelClass", (Object)this.channelClassAsString()).add("Codec", (Object)this.codecAsString()).add("MaximumBitrate", (Object)this.maximumBitrateAsString()).add("MaximumFramerate", (Object)this.maximumFramerateAsString()).add("Resolution", (Object)this.resolutionAsString()).add("ResourceType", (Object)this.resourceTypeAsString()).add("SpecialFeature", (Object)this.specialFeatureAsString()).add("VideoQuality", (Object)this.videoQualityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelClass": {
                return Optional.ofNullable(clazz.cast(this.channelClassAsString()));
            }
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codecAsString()));
            }
            case "MaximumBitrate": {
                return Optional.ofNullable(clazz.cast(this.maximumBitrateAsString()));
            }
            case "MaximumFramerate": {
                return Optional.ofNullable(clazz.cast(this.maximumFramerateAsString()));
            }
            case "Resolution": {
                return Optional.ofNullable(clazz.cast(this.resolutionAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "SpecialFeature": {
                return Optional.ofNullable(clazz.cast(this.specialFeatureAsString()));
            }
            case "VideoQuality": {
                return Optional.ofNullable(clazz.cast(this.videoQualityAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationResourceSpecification, T> g) {
        return obj -> g.apply((ReservationResourceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelClass;
        private String codec;
        private String maximumBitrate;
        private String maximumFramerate;
        private String resolution;
        private String resourceType;
        private String specialFeature;
        private String videoQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationResourceSpecification model) {
            this.channelClass(model.channelClass);
            this.codec(model.codec);
            this.maximumBitrate(model.maximumBitrate);
            this.maximumFramerate(model.maximumFramerate);
            this.resolution(model.resolution);
            this.resourceType(model.resourceType);
            this.specialFeature(model.specialFeature);
            this.videoQuality(model.videoQuality);
        }

        public final String getChannelClass() {
            return this.channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass == null ? null : channelClass.toString());
            return this;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        public final String getCodec() {
            return this.codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(ReservationCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final String getMaximumBitrate() {
            return this.maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        @Override
        public final Builder maximumBitrate(ReservationMaximumBitrate maximumBitrate) {
            this.maximumBitrate(maximumBitrate == null ? null : maximumBitrate.toString());
            return this;
        }

        public final void setMaximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        public final String getMaximumFramerate() {
            return this.maximumFramerate;
        }

        @Override
        public final Builder maximumFramerate(String maximumFramerate) {
            this.maximumFramerate = maximumFramerate;
            return this;
        }

        @Override
        public final Builder maximumFramerate(ReservationMaximumFramerate maximumFramerate) {
            this.maximumFramerate(maximumFramerate == null ? null : maximumFramerate.toString());
            return this;
        }

        public final void setMaximumFramerate(String maximumFramerate) {
            this.maximumFramerate = maximumFramerate;
        }

        public final String getResolution() {
            return this.resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(ReservationResolution resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ReservationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getSpecialFeature() {
            return this.specialFeature;
        }

        @Override
        public final Builder specialFeature(String specialFeature) {
            this.specialFeature = specialFeature;
            return this;
        }

        @Override
        public final Builder specialFeature(ReservationSpecialFeature specialFeature) {
            this.specialFeature(specialFeature == null ? null : specialFeature.toString());
            return this;
        }

        public final void setSpecialFeature(String specialFeature) {
            this.specialFeature = specialFeature;
        }

        public final String getVideoQuality() {
            return this.videoQuality;
        }

        @Override
        public final Builder videoQuality(String videoQuality) {
            this.videoQuality = videoQuality;
            return this;
        }

        @Override
        public final Builder videoQuality(ReservationVideoQuality videoQuality) {
            this.videoQuality(videoQuality == null ? null : videoQuality.toString());
            return this;
        }

        public final void setVideoQuality(String videoQuality) {
            this.videoQuality = videoQuality;
        }

        public ReservationResourceSpecification build() {
            return new ReservationResourceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationResourceSpecification> {
        public Builder channelClass(String var1);

        public Builder channelClass(ChannelClass var1);

        public Builder codec(String var1);

        public Builder codec(ReservationCodec var1);

        public Builder maximumBitrate(String var1);

        public Builder maximumBitrate(ReservationMaximumBitrate var1);

        public Builder maximumFramerate(String var1);

        public Builder maximumFramerate(ReservationMaximumFramerate var1);

        public Builder resolution(String var1);

        public Builder resolution(ReservationResolution var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ReservationResourceType var1);

        public Builder specialFeature(String var1);

        public Builder specialFeature(ReservationSpecialFeature var1);

        public Builder videoQuality(String var1);

        public Builder videoQuality(ReservationVideoQuality var1);
    }
}

