/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchiveGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchiveGroupSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ArchiveGroupSettings.getter(ArchiveGroupSettings::destination)).setter(ArchiveGroupSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Integer> ROLLOVER_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ArchiveGroupSettings.getter(ArchiveGroupSettings::rolloverInterval)).setter(ArchiveGroupSettings.setter(Builder::rolloverInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rolloverInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, ROLLOVER_INTERVAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final OutputLocationRef destination;
    private final Integer rolloverInterval;

    private ArchiveGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.rolloverInterval = builder.rolloverInterval;
    }

    public OutputLocationRef destination() {
        return this.destination;
    }

    public Integer rolloverInterval() {
        return this.rolloverInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolloverInterval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveGroupSettings)) {
            return false;
        }
        ArchiveGroupSettings other = (ArchiveGroupSettings)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.rolloverInterval(), other.rolloverInterval());
    }

    public String toString() {
        return ToString.builder((String)"ArchiveGroupSettings").add("Destination", (Object)this.destination()).add("RolloverInterval", (Object)this.rolloverInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "RolloverInterval": {
                return Optional.ofNullable(clazz.cast(this.rolloverInterval()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveGroupSettings, T> g) {
        return obj -> g.apply((ArchiveGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OutputLocationRef destination;
        private Integer rolloverInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveGroupSettings model) {
            this.destination(model.destination);
            this.rolloverInterval(model.rolloverInterval);
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Integer getRolloverInterval() {
            return this.rolloverInterval;
        }

        @Override
        public final Builder rolloverInterval(Integer rolloverInterval) {
            this.rolloverInterval = rolloverInterval;
            return this;
        }

        public final void setRolloverInterval(Integer rolloverInterval) {
            this.rolloverInterval = rolloverInterval;
        }

        public ArchiveGroupSettings build() {
            return new ArchiveGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchiveGroupSettings> {
        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder rolloverInterval(Integer var1);
    }
}

