/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ColorSpacePassthroughSettings;
import software.amazon.awssdk.services.medialive.model.Rec601Settings;
import software.amazon.awssdk.services.medialive.model.Rec709Settings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H264ColorSpaceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H264ColorSpaceSettings> {
    private static final SdkField<ColorSpacePassthroughSettings> COLOR_SPACE_PASSTHROUGH_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(H264ColorSpaceSettings.getter(H264ColorSpaceSettings::colorSpacePassthroughSettings)).setter(H264ColorSpaceSettings.setter(Builder::colorSpacePassthroughSettings)).constructor(ColorSpacePassthroughSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpacePassthroughSettings").build()}).build();
    private static final SdkField<Rec601Settings> REC601_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(H264ColorSpaceSettings.getter(H264ColorSpaceSettings::rec601Settings)).setter(H264ColorSpaceSettings.setter(Builder::rec601Settings)).constructor(Rec601Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rec601Settings").build()}).build();
    private static final SdkField<Rec709Settings> REC709_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(H264ColorSpaceSettings.getter(H264ColorSpaceSettings::rec709Settings)).setter(H264ColorSpaceSettings.setter(Builder::rec709Settings)).constructor(Rec709Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rec709Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_SPACE_PASSTHROUGH_SETTINGS_FIELD, REC601_SETTINGS_FIELD, REC709_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ColorSpacePassthroughSettings colorSpacePassthroughSettings;
    private final Rec601Settings rec601Settings;
    private final Rec709Settings rec709Settings;

    private H264ColorSpaceSettings(BuilderImpl builder) {
        this.colorSpacePassthroughSettings = builder.colorSpacePassthroughSettings;
        this.rec601Settings = builder.rec601Settings;
        this.rec709Settings = builder.rec709Settings;
    }

    public ColorSpacePassthroughSettings colorSpacePassthroughSettings() {
        return this.colorSpacePassthroughSettings;
    }

    public Rec601Settings rec601Settings() {
        return this.rec601Settings;
    }

    public Rec709Settings rec709Settings() {
        return this.rec709Settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpacePassthroughSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rec601Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rec709Settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264ColorSpaceSettings)) {
            return false;
        }
        H264ColorSpaceSettings other = (H264ColorSpaceSettings)obj;
        return Objects.equals(this.colorSpacePassthroughSettings(), other.colorSpacePassthroughSettings()) && Objects.equals(this.rec601Settings(), other.rec601Settings()) && Objects.equals(this.rec709Settings(), other.rec709Settings());
    }

    public String toString() {
        return ToString.builder((String)"H264ColorSpaceSettings").add("ColorSpacePassthroughSettings", (Object)this.colorSpacePassthroughSettings()).add("Rec601Settings", (Object)this.rec601Settings()).add("Rec709Settings", (Object)this.rec709Settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColorSpacePassthroughSettings": {
                return Optional.ofNullable(clazz.cast(this.colorSpacePassthroughSettings()));
            }
            case "Rec601Settings": {
                return Optional.ofNullable(clazz.cast(this.rec601Settings()));
            }
            case "Rec709Settings": {
                return Optional.ofNullable(clazz.cast(this.rec709Settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264ColorSpaceSettings, T> g) {
        return obj -> g.apply((H264ColorSpaceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColorSpacePassthroughSettings colorSpacePassthroughSettings;
        private Rec601Settings rec601Settings;
        private Rec709Settings rec709Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(H264ColorSpaceSettings model) {
            this.colorSpacePassthroughSettings(model.colorSpacePassthroughSettings);
            this.rec601Settings(model.rec601Settings);
            this.rec709Settings(model.rec709Settings);
        }

        public final ColorSpacePassthroughSettings.Builder getColorSpacePassthroughSettings() {
            return this.colorSpacePassthroughSettings != null ? this.colorSpacePassthroughSettings.toBuilder() : null;
        }

        @Override
        public final Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettings colorSpacePassthroughSettings) {
            this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
            return this;
        }

        public final void setColorSpacePassthroughSettings(ColorSpacePassthroughSettings.BuilderImpl colorSpacePassthroughSettings) {
            this.colorSpacePassthroughSettings = colorSpacePassthroughSettings != null ? colorSpacePassthroughSettings.build() : null;
        }

        public final Rec601Settings.Builder getRec601Settings() {
            return this.rec601Settings != null ? this.rec601Settings.toBuilder() : null;
        }

        @Override
        public final Builder rec601Settings(Rec601Settings rec601Settings) {
            this.rec601Settings = rec601Settings;
            return this;
        }

        public final void setRec601Settings(Rec601Settings.BuilderImpl rec601Settings) {
            this.rec601Settings = rec601Settings != null ? rec601Settings.build() : null;
        }

        public final Rec709Settings.Builder getRec709Settings() {
            return this.rec709Settings != null ? this.rec709Settings.toBuilder() : null;
        }

        @Override
        public final Builder rec709Settings(Rec709Settings rec709Settings) {
            this.rec709Settings = rec709Settings;
            return this;
        }

        public final void setRec709Settings(Rec709Settings.BuilderImpl rec709Settings) {
            this.rec709Settings = rec709Settings != null ? rec709Settings.build() : null;
        }

        public H264ColorSpaceSettings build() {
            return new H264ColorSpaceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H264ColorSpaceSettings> {
        public Builder colorSpacePassthroughSettings(ColorSpacePassthroughSettings var1);

        default public Builder colorSpacePassthroughSettings(Consumer<ColorSpacePassthroughSettings.Builder> colorSpacePassthroughSettings) {
            return this.colorSpacePassthroughSettings((ColorSpacePassthroughSettings)((ColorSpacePassthroughSettings.Builder)ColorSpacePassthroughSettings.builder().applyMutation(colorSpacePassthroughSettings)).build());
        }

        public Builder rec601Settings(Rec601Settings var1);

        default public Builder rec601Settings(Consumer<Rec601Settings.Builder> rec601Settings) {
            return this.rec601Settings((Rec601Settings)((Rec601Settings.Builder)Rec601Settings.builder().applyMutation(rec601Settings)).build());
        }

        public Builder rec709Settings(Rec709Settings var1);

        default public Builder rec709Settings(Consumer<Rec709Settings.Builder> rec709Settings) {
            return this.rec709Settings((Rec709Settings)((Rec709Settings.Builder)Rec709Settings.builder().applyMutation(rec709Settings)).build());
        }
    }
}

