/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.VideoDescription;

@SdkInternalApi
public class VideoDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> CODECSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSettings").build();
    private static final MarshallingInfo<Integer> HEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("height").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> RESPONDTOAFD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("respondToAfd").build();
    private static final MarshallingInfo<String> SCALINGBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scalingBehavior").build();
    private static final MarshallingInfo<Integer> SHARPNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sharpness").build();
    private static final MarshallingInfo<Integer> WIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("width").build();
    private static final VideoDescriptionMarshaller INSTANCE = new VideoDescriptionMarshaller();

    public static VideoDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoDescription videoDescription, ProtocolMarshaller protocolMarshaller) {
        if (videoDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)videoDescription.codecSettings(), CODECSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.height(), HEIGHT_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.respondToAfdString(), RESPONDTOAFD_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.scalingBehaviorString(), SCALINGBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.sharpness(), SHARPNESS_BINDING);
            protocolMarshaller.marshall((Object)videoDescription.width(), WIDTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

