/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.TimecodeConfig;

@SdkInternalApi
public class TimecodeConfigMarshaller {
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<Integer> SYNCTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("syncThreshold").build();
    private static final TimecodeConfigMarshaller INSTANCE = new TimecodeConfigMarshaller();

    public static TimecodeConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimecodeConfig timecodeConfig, ProtocolMarshaller protocolMarshaller) {
        if (timecodeConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)timecodeConfig.sourceString(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)timecodeConfig.syncThreshold(), SYNCTHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

