/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.StaticKeySettings;

@SdkInternalApi
public class StaticKeySettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> KEYPROVIDERSERVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyProviderServer").build();
    private static final MarshallingInfo<String> STATICKEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("staticKeyValue").build();
    private static final StaticKeySettingsMarshaller INSTANCE = new StaticKeySettingsMarshaller();

    public static StaticKeySettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StaticKeySettings staticKeySettings, ProtocolMarshaller protocolMarshaller) {
        if (staticKeySettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)staticKeySettings.keyProviderServer(), KEYPROVIDERSERVER_BINDING);
            protocolMarshaller.marshall((Object)staticKeySettings.staticKeyValue(), STATICKEYVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

