/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.StandardHlsSettings;

@SdkInternalApi
public class StandardHlsSettingsMarshaller {
    private static final MarshallingInfo<String> AUDIORENDITIONSETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioRenditionSets").build();
    private static final MarshallingInfo<StructuredPojo> M3U8SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("m3u8Settings").build();
    private static final StandardHlsSettingsMarshaller INSTANCE = new StandardHlsSettingsMarshaller();

    public static StandardHlsSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StandardHlsSettings standardHlsSettings, ProtocolMarshaller protocolMarshaller) {
        if (standardHlsSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)standardHlsSettings.audioRenditionSets(), AUDIORENDITIONSETS_BINDING);
            protocolMarshaller.marshall((Object)standardHlsSettings.m3u8Settings(), M3U8SETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

