/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.RemixSettings;

@SdkInternalApi
public class RemixSettingsMarshaller {
    private static final MarshallingInfo<List> CHANNELMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelMappings").build();
    private static final MarshallingInfo<Integer> CHANNELSIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelsIn").build();
    private static final MarshallingInfo<Integer> CHANNELSOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelsOut").build();
    private static final RemixSettingsMarshaller INSTANCE = new RemixSettingsMarshaller();

    public static RemixSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RemixSettings remixSettings, ProtocolMarshaller protocolMarshaller) {
        if (remixSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(remixSettings.channelMappings(), CHANNELMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)remixSettings.channelsIn(), CHANNELSIN_BINDING);
            protocolMarshaller.marshall((Object)remixSettings.channelsOut(), CHANNELSOUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

