/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.OutputSettings;

@SdkInternalApi
public class OutputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ARCHIVEOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("archiveOutputSettings").build();
    private static final MarshallingInfo<StructuredPojo> HLSOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsOutputSettings").build();
    private static final MarshallingInfo<StructuredPojo> MSSMOOTHOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("msSmoothOutputSettings").build();
    private static final MarshallingInfo<StructuredPojo> UDPOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("udpOutputSettings").build();
    private static final OutputSettingsMarshaller INSTANCE = new OutputSettingsMarshaller();

    public static OutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputSettings outputSettings, ProtocolMarshaller protocolMarshaller) {
        if (outputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)outputSettings.archiveOutputSettings(), ARCHIVEOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputSettings.hlsOutputSettings(), HLSOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputSettings.msSmoothOutputSettings(), MSSMOOTHOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputSettings.udpOutputSettings(), UDPOUTPUTSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

