/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.NetworkInputSettings;

@SdkInternalApi
public class NetworkInputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> HLSINPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsInputSettings").build();
    private static final MarshallingInfo<String> SERVERVALIDATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverValidation").build();
    private static final NetworkInputSettingsMarshaller INSTANCE = new NetworkInputSettingsMarshaller();

    public static NetworkInputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NetworkInputSettings networkInputSettings, ProtocolMarshaller protocolMarshaller) {
        if (networkInputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)networkInputSettings.hlsInputSettings(), HLSINPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)networkInputSettings.serverValidationString(), SERVERVALIDATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

