/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.Mp2Settings;

@SdkInternalApi
public class Mp2SettingsMarshaller {
    private static final MarshallingInfo<Double> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").build();
    private static final MarshallingInfo<Double> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final Mp2SettingsMarshaller INSTANCE = new Mp2SettingsMarshaller();

    public static Mp2SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Mp2Settings mp2Settings, ProtocolMarshaller protocolMarshaller) {
        if (mp2Settings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mp2Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)mp2Settings.codingModeString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)mp2Settings.sampleRate(), SAMPLERATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

