/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.KeyProviderSettings;
import software.amazon.awssdk.services.medialive.transform.StaticKeySettingsUnmarshaller;

public class KeyProviderSettingsUnmarshaller
implements Unmarshaller<KeyProviderSettings, JsonUnmarshallerContext> {
    private static final KeyProviderSettingsUnmarshaller INSTANCE = new KeyProviderSettingsUnmarshaller();

    public KeyProviderSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyProviderSettings.Builder keyProviderSettingsBuilder = KeyProviderSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("staticKeySettings", targetDepth)) {
                    context.nextToken();
                    keyProviderSettingsBuilder.staticKeySettings(StaticKeySettingsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KeyProviderSettings)keyProviderSettingsBuilder.build();
    }

    public static KeyProviderSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

