/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.InputSource;

public class InputSourceUnmarshaller
implements Unmarshaller<InputSource, JsonUnmarshallerContext> {
    private static final InputSourceUnmarshaller INSTANCE = new InputSourceUnmarshaller();

    public InputSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputSource.Builder inputSourceBuilder = InputSource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("passwordParam", targetDepth)) {
                    context.nextToken();
                    inputSourceBuilder.passwordParam((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("url", targetDepth)) {
                    context.nextToken();
                    inputSourceBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("username", targetDepth)) {
                    context.nextToken();
                    inputSourceBuilder.username((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InputSource)inputSourceBuilder.build();
    }

    public static InputSourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

