/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputSettings;

@SdkInternalApi
public class InputSettingsMarshaller {
    private static final MarshallingInfo<List> AUDIOSELECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioSelectors").build();
    private static final MarshallingInfo<List> CAPTIONSELECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionSelectors").build();
    private static final MarshallingInfo<String> DEBLOCKFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deblockFilter").build();
    private static final MarshallingInfo<String> DENOISEFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("denoiseFilter").build();
    private static final MarshallingInfo<Integer> FILTERSTRENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterStrength").build();
    private static final MarshallingInfo<String> INPUTFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputFilter").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKINPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkInputSettings").build();
    private static final MarshallingInfo<String> SOURCEENDBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceEndBehavior").build();
    private static final MarshallingInfo<StructuredPojo> VIDEOSELECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoSelector").build();
    private static final InputSettingsMarshaller INSTANCE = new InputSettingsMarshaller();

    public static InputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputSettings inputSettings, ProtocolMarshaller protocolMarshaller) {
        if (inputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(inputSettings.audioSelectors(), AUDIOSELECTORS_BINDING);
            protocolMarshaller.marshall(inputSettings.captionSelectors(), CAPTIONSELECTORS_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.deblockFilterString(), DEBLOCKFILTER_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.denoiseFilterString(), DENOISEFILTER_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.filterStrength(), FILTERSTRENGTH_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.inputFilterString(), INPUTFILTER_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.networkInputSettings(), NETWORKINPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.sourceEndBehaviorString(), SOURCEENDBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)inputSettings.videoSelector(), VIDEOSELECTOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

