/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.InputSecurityGroup;

@SdkInternalApi
public class InputSecurityGroupMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<List> WHITELISTRULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitelistRules").build();
    private static final InputSecurityGroupMarshaller INSTANCE = new InputSecurityGroupMarshaller();

    public static InputSecurityGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputSecurityGroup inputSecurityGroup, ProtocolMarshaller protocolMarshaller) {
        if (inputSecurityGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputSecurityGroup.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)inputSecurityGroup.id(), ID_BINDING);
            protocolMarshaller.marshall(inputSecurityGroup.whitelistRules(), WHITELISTRULES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

