/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.InputLocation;

@SdkInternalApi
public class InputLocationMarshaller {
    private static final MarshallingInfo<String> PASSWORDPARAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passwordParam").build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uri").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").build();
    private static final InputLocationMarshaller INSTANCE = new InputLocationMarshaller();

    public static InputLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputLocation inputLocation, ProtocolMarshaller protocolMarshaller) {
        if (inputLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputLocation.passwordParam(), PASSWORDPARAM_BINDING);
            protocolMarshaller.marshall((Object)inputLocation.uri(), URI_BINDING);
            protocolMarshaller.marshall((Object)inputLocation.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

