/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.InputChannelLevel;

@SdkInternalApi
public class InputChannelLevelMarshaller {
    private static final MarshallingInfo<Integer> GAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gain").build();
    private static final MarshallingInfo<Integer> INPUTCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputChannel").build();
    private static final InputChannelLevelMarshaller INSTANCE = new InputChannelLevelMarshaller();

    public static InputChannelLevelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputChannelLevel inputChannelLevel, ProtocolMarshaller protocolMarshaller) {
        if (inputChannelLevel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputChannelLevel.gain(), GAIN_BINDING);
            protocolMarshaller.marshall((Object)inputChannelLevel.inputChannel(), INPUTCHANNEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

