/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.HlsWebdavSettings;

@SdkInternalApi
public class HlsWebdavSettingsMarshaller {
    private static final MarshallingInfo<Integer> CONNECTIONRETRYINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionRetryInterval").build();
    private static final MarshallingInfo<Integer> FILECACHEDURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filecacheDuration").build();
    private static final MarshallingInfo<String> HTTPTRANSFERMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpTransferMode").build();
    private static final MarshallingInfo<Integer> NUMRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numRetries").build();
    private static final MarshallingInfo<Integer> RESTARTDELAY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("restartDelay").build();
    private static final HlsWebdavSettingsMarshaller INSTANCE = new HlsWebdavSettingsMarshaller();

    public static HlsWebdavSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsWebdavSettings hlsWebdavSettings, ProtocolMarshaller protocolMarshaller) {
        if (hlsWebdavSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hlsWebdavSettings.connectionRetryInterval(), CONNECTIONRETRYINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)hlsWebdavSettings.filecacheDuration(), FILECACHEDURATION_BINDING);
            protocolMarshaller.marshall((Object)hlsWebdavSettings.httpTransferModeString(), HTTPTRANSFERMODE_BINDING);
            protocolMarshaller.marshall((Object)hlsWebdavSettings.numRetries(), NUMRETRIES_BINDING);
            protocolMarshaller.marshall((Object)hlsWebdavSettings.restartDelay(), RESTARTDELAY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

