/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsOutputSettings;

@SdkInternalApi
public class HlsOutputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> HLSSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsSettings").build();
    private static final MarshallingInfo<String> NAMEMODIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nameModifier").build();
    private static final MarshallingInfo<String> SEGMENTMODIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentModifier").build();
    private static final HlsOutputSettingsMarshaller INSTANCE = new HlsOutputSettingsMarshaller();

    public static HlsOutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsOutputSettings hlsOutputSettings, ProtocolMarshaller protocolMarshaller) {
        if (hlsOutputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hlsOutputSettings.hlsSettings(), HLSSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsOutputSettings.nameModifier(), NAMEMODIFIER_BINDING);
            protocolMarshaller.marshall((Object)hlsOutputSettings.segmentModifier(), SEGMENTMODIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

