/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsGroupSettings;

@SdkInternalApi
public class HlsGroupSettingsMarshaller {
    private static final MarshallingInfo<List> ADMARKERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adMarkers").build();
    private static final MarshallingInfo<String> BASEURLCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseUrlContent").build();
    private static final MarshallingInfo<String> BASEURLMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseUrlManifest").build();
    private static final MarshallingInfo<List> CAPTIONLANGUAGEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionLanguageMappings").build();
    private static final MarshallingInfo<String> CAPTIONLANGUAGESETTING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionLanguageSetting").build();
    private static final MarshallingInfo<String> CLIENTCACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCache").build();
    private static final MarshallingInfo<String> CODECSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSpecification").build();
    private static final MarshallingInfo<String> CONSTANTIV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("constantIv").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").build();
    private static final MarshallingInfo<String> DIRECTORYSTRUCTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("directoryStructure").build();
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionType").build();
    private static final MarshallingInfo<StructuredPojo> HLSCDNSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsCdnSettings").build();
    private static final MarshallingInfo<Integer> INDEXNSEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("indexNSegments").build();
    private static final MarshallingInfo<String> INPUTLOSSACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputLossAction").build();
    private static final MarshallingInfo<String> IVINMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ivInManifest").build();
    private static final MarshallingInfo<String> IVSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ivSource").build();
    private static final MarshallingInfo<Integer> KEEPSEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keepSegments").build();
    private static final MarshallingInfo<String> KEYFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyFormat").build();
    private static final MarshallingInfo<String> KEYFORMATVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyFormatVersions").build();
    private static final MarshallingInfo<StructuredPojo> KEYPROVIDERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyProviderSettings").build();
    private static final MarshallingInfo<String> MANIFESTCOMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestCompression").build();
    private static final MarshallingInfo<String> MANIFESTDURATIONFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestDurationFormat").build();
    private static final MarshallingInfo<Integer> MINSEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minSegmentLength").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mode").build();
    private static final MarshallingInfo<String> OUTPUTSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputSelection").build();
    private static final MarshallingInfo<String> PROGRAMDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programDateTime").build();
    private static final MarshallingInfo<Integer> PROGRAMDATETIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programDateTimePeriod").build();
    private static final MarshallingInfo<Integer> SEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentLength").build();
    private static final MarshallingInfo<String> SEGMENTATIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentationMode").build();
    private static final MarshallingInfo<Integer> SEGMENTSPERSUBDIRECTORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentsPerSubdirectory").build();
    private static final MarshallingInfo<String> STREAMINFRESOLUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamInfResolution").build();
    private static final MarshallingInfo<String> TIMEDMETADATAID3FRAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataId3Frame").build();
    private static final MarshallingInfo<Integer> TIMEDMETADATAID3PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataId3Period").build();
    private static final MarshallingInfo<Integer> TIMESTAMPDELTAMILLISECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestampDeltaMilliseconds").build();
    private static final MarshallingInfo<String> TSFILEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tsFileMode").build();
    private static final HlsGroupSettingsMarshaller INSTANCE = new HlsGroupSettingsMarshaller();

    public static HlsGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsGroupSettings hlsGroupSettings, ProtocolMarshaller protocolMarshaller) {
        if (hlsGroupSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hlsGroupSettings.adMarkersStrings(), ADMARKERS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.baseUrlContent(), BASEURLCONTENT_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.baseUrlManifest(), BASEURLMANIFEST_BINDING);
            protocolMarshaller.marshall(hlsGroupSettings.captionLanguageMappings(), CAPTIONLANGUAGEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.captionLanguageSettingString(), CAPTIONLANGUAGESETTING_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.clientCacheString(), CLIENTCACHE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.codecSpecificationString(), CODECSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.constantIv(), CONSTANTIV_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.directoryStructureString(), DIRECTORYSTRUCTURE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.encryptionTypeString(), ENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.hlsCdnSettings(), HLSCDNSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.indexNSegments(), INDEXNSEGMENTS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.inputLossActionString(), INPUTLOSSACTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.ivInManifestString(), IVINMANIFEST_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.ivSourceString(), IVSOURCE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.keepSegments(), KEEPSEGMENTS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.keyFormat(), KEYFORMAT_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.keyFormatVersions(), KEYFORMATVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.keyProviderSettings(), KEYPROVIDERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.manifestCompressionString(), MANIFESTCOMPRESSION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.manifestDurationFormatString(), MANIFESTDURATIONFORMAT_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.minSegmentLength(), MINSEGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.modeString(), MODE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.outputSelectionString(), OUTPUTSELECTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.programDateTimeString(), PROGRAMDATETIME_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.programDateTimePeriod(), PROGRAMDATETIMEPERIOD_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentLength(), SEGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentationModeString(), SEGMENTATIONMODE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentsPerSubdirectory(), SEGMENTSPERSUBDIRECTORY_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.streamInfResolutionString(), STREAMINFRESOLUTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timedMetadataId3FrameString(), TIMEDMETADATAID3FRAME_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timedMetadataId3Period(), TIMEDMETADATAID3PERIOD_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timestampDeltaMilliseconds(), TIMESTAMPDELTAMILLISECONDS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.tsFileModeString(), TSFILEMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

