/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.H264Settings;

public class H264SettingsUnmarshaller
implements Unmarshaller<H264Settings, JsonUnmarshallerContext> {
    private static final H264SettingsUnmarshaller INSTANCE = new H264SettingsUnmarshaller();

    public H264Settings unmarshall(JsonUnmarshallerContext context) throws Exception {
        H264Settings.Builder h264SettingsBuilder = H264Settings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("adaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.adaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("afdSignaling", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.afdSignaling((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("bitrate", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.bitrate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("bufFillPct", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.bufFillPct((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("bufSize", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.bufSize((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("colorMetadata", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.colorMetadata((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("entropyEncoding", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.entropyEncoding((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fixedAfd", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.fixedAfd((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("flickerAq", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.flickerAq((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateControl", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.framerateControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateDenominator", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.framerateDenominator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateNumerator", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.framerateNumerator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopBReference", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopBReference((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopClosedCadence", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopClosedCadence((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopNumBFrames", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopNumBFrames((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopSize", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopSize((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopSizeUnits", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopSizeUnits((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("level", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.level((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("lookAheadRateControl", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.lookAheadRateControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("maxBitrate", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.maxBitrate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("minIInterval", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.minIInterval((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("numRefFrames", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.numRefFrames((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("parControl", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.parControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("parDenominator", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.parDenominator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("parNumerator", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.parNumerator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("profile", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.profile((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("rateControlMode", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.rateControlMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("scanType", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.scanType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sceneChangeDetect", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.sceneChangeDetect((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("slices", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.slices((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("softness", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.softness((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("spatialAq", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.spatialAq((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("syntax", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.syntax((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("temporalAq", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.temporalAq((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("timecodeInsertion", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.timecodeInsertion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (H264Settings)h264SettingsBuilder.build();
    }

    public static H264SettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

