/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.GlobalConfiguration;

@SdkInternalApi
public class GlobalConfigurationMarshaller {
    private static final MarshallingInfo<Integer> INITIALAUDIOGAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("initialAudioGain").build();
    private static final MarshallingInfo<String> INPUTENDACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputEndAction").build();
    private static final MarshallingInfo<StructuredPojo> INPUTLOSSBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputLossBehavior").build();
    private static final MarshallingInfo<String> OUTPUTTIMINGSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputTimingSource").build();
    private static final MarshallingInfo<String> SUPPORTLOWFRAMERATEINPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportLowFramerateInputs").build();
    private static final GlobalConfigurationMarshaller INSTANCE = new GlobalConfigurationMarshaller();

    public static GlobalConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlobalConfiguration globalConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (globalConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)globalConfiguration.initialAudioGain(), INITIALAUDIOGAIN_BINDING);
            protocolMarshaller.marshall((Object)globalConfiguration.inputEndActionString(), INPUTENDACTION_BINDING);
            protocolMarshaller.marshall((Object)globalConfiguration.inputLossBehavior(), INPUTLOSSBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)globalConfiguration.outputTimingSourceString(), OUTPUTTIMINGSOURCE_BINDING);
            protocolMarshaller.marshall((Object)globalConfiguration.supportLowFramerateInputsString(), SUPPORTLOWFRAMERATEINPUTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

