/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.FecOutputSettings;

@SdkInternalApi
public class FecOutputSettingsMarshaller {
    private static final MarshallingInfo<Integer> COLUMNDEPTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("columnDepth").build();
    private static final MarshallingInfo<String> INCLUDEFEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("includeFec").build();
    private static final MarshallingInfo<Integer> ROWLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rowLength").build();
    private static final FecOutputSettingsMarshaller INSTANCE = new FecOutputSettingsMarshaller();

    public static FecOutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FecOutputSettings fecOutputSettings, ProtocolMarshaller protocolMarshaller) {
        if (fecOutputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fecOutputSettings.columnDepth(), COLUMNDEPTH_BINDING);
            protocolMarshaller.marshall((Object)fecOutputSettings.includeFecString(), INCLUDEFEC_BINDING);
            protocolMarshaller.marshall((Object)fecOutputSettings.rowLength(), ROWLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

