/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.EncoderSettings;

@SdkInternalApi
public class EncoderSettingsMarshaller {
    private static final MarshallingInfo<List> AUDIODESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioDescriptions").build();
    private static final MarshallingInfo<StructuredPojo> AVAILBLANKING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availBlanking").build();
    private static final MarshallingInfo<StructuredPojo> AVAILCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> BLACKOUTSLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blackoutSlate").build();
    private static final MarshallingInfo<List> CAPTIONDESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionDescriptions").build();
    private static final MarshallingInfo<StructuredPojo> GLOBALCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("globalConfiguration").build();
    private static final MarshallingInfo<List> OUTPUTGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputGroups").build();
    private static final MarshallingInfo<StructuredPojo> TIMECODECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeConfig").build();
    private static final MarshallingInfo<List> VIDEODESCRIPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoDescriptions").build();
    private static final EncoderSettingsMarshaller INSTANCE = new EncoderSettingsMarshaller();

    public static EncoderSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EncoderSettings encoderSettings, ProtocolMarshaller protocolMarshaller) {
        if (encoderSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(encoderSettings.audioDescriptions(), AUDIODESCRIPTIONS_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.availBlanking(), AVAILBLANKING_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.availConfiguration(), AVAILCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.blackoutSlate(), BLACKOUTSLATE_BINDING);
            protocolMarshaller.marshall(encoderSettings.captionDescriptions(), CAPTIONDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.globalConfiguration(), GLOBALCONFIGURATION_BINDING);
            protocolMarshaller.marshall(encoderSettings.outputGroups(), OUTPUTGROUPS_BINDING);
            protocolMarshaller.marshall((Object)encoderSettings.timecodeConfig(), TIMECODECONFIG_BINDING);
            protocolMarshaller.marshall(encoderSettings.videoDescriptions(), VIDEODESCRIPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

