/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.EmbeddedSourceSettings;

@SdkInternalApi
public class EmbeddedSourceSettingsMarshaller {
    private static final MarshallingInfo<String> CONVERT608TO708_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("convert608To708").build();
    private static final MarshallingInfo<String> SCTE20DETECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte20Detection").build();
    private static final MarshallingInfo<Integer> SOURCE608CHANNELNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source608ChannelNumber").build();
    private static final MarshallingInfo<Integer> SOURCE608TRACKNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source608TrackNumber").build();
    private static final EmbeddedSourceSettingsMarshaller INSTANCE = new EmbeddedSourceSettingsMarshaller();

    public static EmbeddedSourceSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EmbeddedSourceSettings embeddedSourceSettings, ProtocolMarshaller protocolMarshaller) {
        if (embeddedSourceSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)embeddedSourceSettings.convert608To708String(), CONVERT608TO708_BINDING);
            protocolMarshaller.marshall((Object)embeddedSourceSettings.scte20DetectionString(), SCTE20DETECTION_BINDING);
            protocolMarshaller.marshall((Object)embeddedSourceSettings.source608ChannelNumber(), SOURCE608CHANNELNUMBER_BINDING);
            protocolMarshaller.marshall((Object)embeddedSourceSettings.source608TrackNumber(), SOURCE608TRACKNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

