/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.Eac3Settings;

@SdkInternalApi
public class Eac3SettingsMarshaller {
    private static final MarshallingInfo<String> ATTENUATIONCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attenuationControl").build();
    private static final MarshallingInfo<Double> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").build();
    private static final MarshallingInfo<String> BITSTREAMMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitstreamMode").build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").build();
    private static final MarshallingInfo<String> DCFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dcFilter").build();
    private static final MarshallingInfo<Integer> DIALNORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dialnorm").build();
    private static final MarshallingInfo<String> DRCLINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("drcLine").build();
    private static final MarshallingInfo<String> DRCRF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("drcRf").build();
    private static final MarshallingInfo<String> LFECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lfeControl").build();
    private static final MarshallingInfo<String> LFEFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lfeFilter").build();
    private static final MarshallingInfo<Double> LOROCENTERMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loRoCenterMixLevel").build();
    private static final MarshallingInfo<Double> LOROSURROUNDMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loRoSurroundMixLevel").build();
    private static final MarshallingInfo<Double> LTRTCENTERMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ltRtCenterMixLevel").build();
    private static final MarshallingInfo<Double> LTRTSURROUNDMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ltRtSurroundMixLevel").build();
    private static final MarshallingInfo<String> METADATACONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadataControl").build();
    private static final MarshallingInfo<String> PASSTHROUGHCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passthroughControl").build();
    private static final MarshallingInfo<String> PHASECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseControl").build();
    private static final MarshallingInfo<String> STEREODOWNMIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stereoDownmix").build();
    private static final MarshallingInfo<String> SURROUNDEXMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("surroundExMode").build();
    private static final MarshallingInfo<String> SURROUNDMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("surroundMode").build();
    private static final Eac3SettingsMarshaller INSTANCE = new Eac3SettingsMarshaller();

    public static Eac3SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Eac3Settings eac3Settings, ProtocolMarshaller protocolMarshaller) {
        if (eac3Settings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eac3Settings.attenuationControlString(), ATTENUATIONCONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.bitstreamModeString(), BITSTREAMMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.codingModeString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.dcFilterString(), DCFILTER_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.dialnorm(), DIALNORM_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.drcLineString(), DRCLINE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.drcRfString(), DRCRF_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.lfeControlString(), LFECONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.lfeFilterString(), LFEFILTER_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.loRoCenterMixLevel(), LOROCENTERMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.loRoSurroundMixLevel(), LOROSURROUNDMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.ltRtCenterMixLevel(), LTRTCENTERMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.ltRtSurroundMixLevel(), LTRTSURROUNDMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.metadataControlString(), METADATACONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.passthroughControlString(), PASSTHROUGHCONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.phaseControlString(), PHASECONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.stereoDownmixString(), STEREODOWNMIX_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.surroundExModeString(), SURROUNDEXMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.surroundModeString(), SURROUNDMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

