/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.DvbNitSettings;

@SdkInternalApi
public class DvbNitSettingsMarshaller {
    private static final MarshallingInfo<Integer> NETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkId").build();
    private static final MarshallingInfo<String> NETWORKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkName").build();
    private static final MarshallingInfo<Integer> REPINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repInterval").build();
    private static final DvbNitSettingsMarshaller INSTANCE = new DvbNitSettingsMarshaller();

    public static DvbNitSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DvbNitSettings dvbNitSettings, ProtocolMarshaller protocolMarshaller) {
        if (dvbNitSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dvbNitSettings.networkId(), NETWORKID_BINDING);
            protocolMarshaller.marshall((Object)dvbNitSettings.networkName(), NETWORKNAME_BINDING);
            protocolMarshaller.marshall((Object)dvbNitSettings.repInterval(), REPINTERVAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

