/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.CaptionSelectorSettings;

@SdkInternalApi
public class CaptionSelectorSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ARIBSOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("aribSourceSettings").build();
    private static final MarshallingInfo<StructuredPojo> DVBSUBSOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbSubSourceSettings").build();
    private static final MarshallingInfo<StructuredPojo> EMBEDDEDSOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("embeddedSourceSettings").build();
    private static final MarshallingInfo<StructuredPojo> SCTE20SOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte20SourceSettings").build();
    private static final MarshallingInfo<StructuredPojo> SCTE27SOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte27SourceSettings").build();
    private static final MarshallingInfo<StructuredPojo> TELETEXTSOURCESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("teletextSourceSettings").build();
    private static final CaptionSelectorSettingsMarshaller INSTANCE = new CaptionSelectorSettingsMarshaller();

    public static CaptionSelectorSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaptionSelectorSettings captionSelectorSettings, ProtocolMarshaller protocolMarshaller) {
        if (captionSelectorSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)captionSelectorSettings.aribSourceSettings(), ARIBSOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSelectorSettings.dvbSubSourceSettings(), DVBSUBSOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSelectorSettings.embeddedSourceSettings(), EMBEDDEDSOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSelectorSettings.scte20SourceSettings(), SCTE20SOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSelectorSettings.scte27SourceSettings(), SCTE27SOURCESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionSelectorSettings.teletextSourceSettings(), TELETEXTSOURCESETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

