/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.BlackoutSlate;

@SdkInternalApi
public class BlackoutSlateMarshaller {
    private static final MarshallingInfo<StructuredPojo> BLACKOUTSLATEIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blackoutSlateImage").build();
    private static final MarshallingInfo<String> NETWORKENDBLACKOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkEndBlackout").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKENDBLACKOUTIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkEndBlackoutImage").build();
    private static final MarshallingInfo<String> NETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final BlackoutSlateMarshaller INSTANCE = new BlackoutSlateMarshaller();

    public static BlackoutSlateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BlackoutSlate blackoutSlate, ProtocolMarshaller protocolMarshaller) {
        if (blackoutSlate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)blackoutSlate.blackoutSlateImage(), BLACKOUTSLATEIMAGE_BINDING);
            protocolMarshaller.marshall((Object)blackoutSlate.networkEndBlackoutString(), NETWORKENDBLACKOUT_BINDING);
            protocolMarshaller.marshall((Object)blackoutSlate.networkEndBlackoutImage(), NETWORKENDBLACKOUTIMAGE_BINDING);
            protocolMarshaller.marshall((Object)blackoutSlate.networkId(), NETWORKID_BINDING);
            protocolMarshaller.marshall((Object)blackoutSlate.stateString(), STATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

