/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AvailSettings;

@SdkInternalApi
public class AvailSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> SCTE35SPLICEINSERT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35SpliceInsert").build();
    private static final MarshallingInfo<StructuredPojo> SCTE35TIMESIGNALAPOS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35TimeSignalApos").build();
    private static final AvailSettingsMarshaller INSTANCE = new AvailSettingsMarshaller();

    public static AvailSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AvailSettings availSettings, ProtocolMarshaller protocolMarshaller) {
        if (availSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)availSettings.scte35SpliceInsert(), SCTE35SPLICEINSERT_BINDING);
            protocolMarshaller.marshall((Object)availSettings.scte35TimeSignalApos(), SCTE35TIMESIGNALAPOS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

