/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioSelectorSettings;

@SdkInternalApi
public class AudioSelectorSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUDIOLANGUAGESELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioLanguageSelection").build();
    private static final MarshallingInfo<StructuredPojo> AUDIOPIDSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioPidSelection").build();
    private static final AudioSelectorSettingsMarshaller INSTANCE = new AudioSelectorSettingsMarshaller();

    public static AudioSelectorSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioSelectorSettings audioSelectorSettings, ProtocolMarshaller protocolMarshaller) {
        if (audioSelectorSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)audioSelectorSettings.audioLanguageSelection(), AUDIOLANGUAGESELECTION_BINDING);
            protocolMarshaller.marshall((Object)audioSelectorSettings.audioPidSelection(), AUDIOPIDSELECTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

