/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.AudioNormalizationSettings;

@SdkInternalApi
public class AudioNormalizationSettingsMarshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithm").build();
    private static final MarshallingInfo<String> ALGORITHMCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithmControl").build();
    private static final MarshallingInfo<Double> TARGETLKFS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetLkfs").build();
    private static final AudioNormalizationSettingsMarshaller INSTANCE = new AudioNormalizationSettingsMarshaller();

    public static AudioNormalizationSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioNormalizationSettings audioNormalizationSettings, ProtocolMarshaller protocolMarshaller) {
        if (audioNormalizationSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)audioNormalizationSettings.algorithmString(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)audioNormalizationSettings.algorithmControlString(), ALGORITHMCONTROL_BINDING);
            protocolMarshaller.marshall((Object)audioNormalizationSettings.targetLkfs(), TARGETLKFS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

