/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.AudioLanguageSelection;

@SdkInternalApi
public class AudioLanguageSelectionMarshaller {
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").build();
    private static final MarshallingInfo<String> LANGUAGESELECTIONPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageSelectionPolicy").build();
    private static final AudioLanguageSelectionMarshaller INSTANCE = new AudioLanguageSelectionMarshaller();

    public static AudioLanguageSelectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioLanguageSelection audioLanguageSelection, ProtocolMarshaller protocolMarshaller) {
        if (audioLanguageSelection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)audioLanguageSelection.languageCode(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)audioLanguageSelection.languageSelectionPolicyString(), LANGUAGESELECTIONPOLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

