/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioDescription;

@SdkInternalApi
public class AudioDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUDIONORMALIZATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioNormalizationSettings").build();
    private static final MarshallingInfo<String> AUDIOSELECTORNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioSelectorName").build();
    private static final MarshallingInfo<String> AUDIOTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioType").build();
    private static final MarshallingInfo<String> AUDIOTYPECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioTypeControl").build();
    private static final MarshallingInfo<StructuredPojo> CODECSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSettings").build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").build();
    private static final MarshallingInfo<String> LANGUAGECODECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCodeControl").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> REMIXSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remixSettings").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").build();
    private static final AudioDescriptionMarshaller INSTANCE = new AudioDescriptionMarshaller();

    public static AudioDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioDescription audioDescription, ProtocolMarshaller protocolMarshaller) {
        if (audioDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)audioDescription.audioNormalizationSettings(), AUDIONORMALIZATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.audioSelectorName(), AUDIOSELECTORNAME_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.audioTypeString(), AUDIOTYPE_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.audioTypeControlString(), AUDIOTYPECONTROL_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.codecSettings(), CODECSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.languageCode(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.languageCodeControlString(), LANGUAGECODECONTROL_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.remixSettings(), REMIXSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.streamName(), STREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

