/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.AudioChannelMapping;

@SdkInternalApi
public class AudioChannelMappingMarshaller {
    private static final MarshallingInfo<List> INPUTCHANNELLEVELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputChannelLevels").build();
    private static final MarshallingInfo<Integer> OUTPUTCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputChannel").build();
    private static final AudioChannelMappingMarshaller INSTANCE = new AudioChannelMappingMarshaller();

    public static AudioChannelMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioChannelMapping audioChannelMapping, ProtocolMarshaller protocolMarshaller) {
        if (audioChannelMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(audioChannelMapping.inputChannelLevels(), INPUTCHANNELLEVELS_BINDING);
            protocolMarshaller.marshall((Object)audioChannelMapping.outputChannel(), OUTPUTCHANNEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

