/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings;

@SdkInternalApi
public class ArchiveOutputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CONTAINERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerSettings").build();
    private static final MarshallingInfo<String> EXTENSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extension").build();
    private static final MarshallingInfo<String> NAMEMODIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nameModifier").build();
    private static final ArchiveOutputSettingsMarshaller INSTANCE = new ArchiveOutputSettingsMarshaller();

    public static ArchiveOutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ArchiveOutputSettings archiveOutputSettings, ProtocolMarshaller protocolMarshaller) {
        if (archiveOutputSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)archiveOutputSettings.containerSettings(), CONTAINERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)archiveOutputSettings.extension(), EXTENSION_BINDING);
            protocolMarshaller.marshall((Object)archiveOutputSettings.nameModifier(), NAMEMODIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

